% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_nullcheck.R
\name{flash_nullcheck}
\alias{flash_nullcheck}
\title{Nullcheck flash factors}
\usage{
flash_nullcheck(flash, kset = NULL, remove = TRUE, tol = NULL, verbose = NULL)
}
\arguments{
\item{flash}{A \code{flash} or \code{flash_fit} object.}

\item{kset}{A vector of integers specifying which factors to nullcheck.
If \code{kset = NULL}, then all existing factors will be checked.}

\item{remove}{Whether to remove factors that have been set to zero from the
\code{flash} object. Note that this might change the indices of existing
factors.}

\item{tol}{The "tolerance" parameter: if a factor does not improve the ELBO
by at least \code{tol}, then it will be set to zero. Note that
\code{flash_nullcheck} does not respect "global" tolerance parameters set
by \code{\link{flash_set_conv_crit}} (which only affects the convergence
tolerance for greedy fits and backfits). The default tolerance is
\eqn{np\sqrt{\epsilon}}, where \eqn{n} is the
number of rows in the dataset, \eqn{p} is the number of columns, and
\eqn{\epsilon} is equal to \code{\link{.Machine}$double.eps}.}

\item{verbose}{When and how to display progress updates. For nullchecks,
updates are only displayed when \code{verbose} > 0.}
}
\value{
The \code{\link{flash}} object from argument \code{flash}, with
  factors that do not improve the ELBO by at least \code{tol} either set
  to zero or removed (depending on the argument to parameter \code{remove}).
}
\description{
Sets factor/loadings pairs to zero if doing so improves the variational
  lower bound (ELBO). See \code{\link{flash}} for examples of usage.
}
\seealso{
\code{\link{flash_factors_remove}},
  \code{\link{flash_factors_set_to_zero}}
}
