% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_greedy.R
\name{flash_greedy}
\alias{flash_greedy}
\title{Greedily add factors to a flash object}
\usage{
flash_greedy(
  flash,
  Kmax = 1,
  ebnm_fn = ebnm_point_normal,
  init_fn = NULL,
  extrapolate = FALSE,
  warmstart = FALSE,
  maxiter = 500,
  tol = NULL,
  verbose = NULL
)
}
\arguments{
\item{flash}{A \code{flash} or \code{flash_fit} object to which factors are
to be added.}

\item{Kmax}{The maximum number of factors to be added. This will not
necessarily be the total number of factors added by
\code{flash_greedy}, since factors are only added as long as they
increase the ELBO.}

\item{ebnm_fn}{The function or functions used to solve the empirical Bayes
  normal means (EBNM) subproblems. Most importantly, these functions specify
  the families of distributions \eqn{G_\ell^{(k)}} and \eqn{G_f^{(k)}} to which the
  priors on loadings and factors \eqn{g_\ell^{(k)}} and \eqn{g_f^{(k)}} are
  assumed to belong. If the same function is to be used for both loadings
  \eqn{L} and factors \eqn{F}, then \code{ebnm_fn} can be a single function.
  If one function is to be used for loadings and a second for factors,
  then \code{ebnm_fn} should be a list of length two, with the first
  element giving the function for loadings and the second the function
  for factors. If different functions are to be used for different values of
  \eqn{k}, then factor/loadings pairs must be added successively using
  multiple calls to either \code{\link{flash_greedy}} or
  \code{\link{flash_factors_init}}.

  Any EBNM function provided by package \code{\link[ebnm]{ebnm}} can be
  used as input. Non-default arguments to parameters can be supplied using
  the helper function \code{\link{flash_ebnm}}. Custom EBNM functions can
  also be used: for details, see \code{\link{flash_ebnm}}.}

\item{init_fn}{The function used to initialize factor/loadings pairs. Functions
\code{\link{flash_greedy_init_default}}, \code{\link{flash_greedy_init_softImpute}}, and
\code{\link{flash_greedy_init_irlba}} have been supplied; note, in particular, that
\code{\link{flash_greedy_init_softImpute}} can yield better results than the
default initialization function when there is missing data. Custom
initialization functions may also be used. If \code{init_fn = NULL} then
\code{\link{flash_greedy_init_default}} will be used, with an attempt made to set
argument \code{sign_constraints} appropriately via test calls to
the EBNM function(s) specified by parameter \code{ebnm_fn}. If factors or loadings
are constrained in some other fashion (e.g., bounded support), then the
initialization function should be modified to account for the constraints
--- otherwise, the greedy algorithm can stop adding factor/loadings pairs
too early. Custom initialization functions should accept a single
parameter referring to a \code{\link{flash_fit}} object and should output
a list consisting of two vectors, which will be used as initial values for
the new loadings \eqn{\ell_{\cdot k}} and the new factor \eqn{f_{\cdot k}}. Typically,
a custom initialization function will extract the matrix of residuals from
the \code{flash_fit} object using method \code{residuals.flash_fit} and
then return a (possibly constrained) rank-one approximation to the matrix
of residuals. See \strong{Examples} below.}

\item{extrapolate}{Whether to use an extrapolation technique
inspired by Ang and Gillis (2019) to accelerate the fitting process.
Control parameters are handled via global options and can be set by
calling \code{options("extrapolate.control") <- control.param}.}

\item{warmstart}{Whether to use "warmstarts" when solving the EBNM
subproblems by initializing solutions at the previous value of the fitted
prior \eqn{\hat{g}}. An important side effect of warmstarts for
\code{ashr}-like prior families is to fix the grid at its initial setting.
Fixing the grid can lead to poor fits if there
are large changes in the scale of the estimated prior over the
course of the fitting process. However, allowing the grid to
vary can occasionally result in decreases in ELBO.}

\item{maxiter}{The maximum number of iterations when optimizing a greedily
added factor/loadings pair.}

\item{tol}{The convergence tolerance parameter. At each iteration, the fit
is compared to the fit from the previous iteration using a convergence
criterion function (by default, the difference in ELBO, but the criterion
can be changed via \code{\link{flash_set_conv_crit}}). When
the value returned by this function is less than or equal to \code{tol},
the newly added factor/loadings pair is considered to have "converged,"
so that \code{flash_greedy} moves on and attempts to add another new
factor (or, if the maximum number of factors \code{Kmax} has been reached,
the process terminates). Note that
specifying \code{tol} here will override any value set by
\code{flash_set_conv_crit}; to use the "global" tolerance parameter,
\code{tol} must be left unspecified (\code{NULL}).
If \code{tol = NULL} and a global tolerance
parameter has not been set, then the default
tolerance used is \eqn{np\sqrt{\epsilon}}, where \eqn{n} is the
number of rows in the dataset, \eqn{p} is the number of columns, and
\eqn{\epsilon} is equal to \code{\link{.Machine}$double.eps}.}

\item{verbose}{When and how to display progress updates. Set to
\code{0} for none, \code{1} for updates after a factor is added or a
backfit is completed, \code{2} for additional notifications about the
variational lower bound, and \code{3} for updates after every iteration.
It is also possible to output a single tab-delimited table of values
using function \code{\link{flash_set_verbose}} with \code{verbose = -1}.}
}
\value{
The \code{\link{flash}} object from argument \code{flash}, with up
  to \code{Kmax} new factor/loadings pairs "greedily" added.
}
\description{
Adds factor/loadings pairs to a flash object in a "greedy" manner. Up to
  \code{Kmax} pairs are added one at a time. At each step, \code{flash_greedy}
  attempts to find an optimal additional (rank-one) factor given all
  previously added factors. The additional factor is retained if it
  increases the variational lower bound (ELBO); otherwise, fitting terminates.
  See \code{\link{flash}} for examples of usage.
}
\examples{
# The following are examples of advanced usage. See ?flash for basic usage.

# Increase the maximum number of iterations in the default initialization
#   method.
my_init_fn <- function(f) flash_greedy_init_default(f, maxiter = 500)
fl <- flash_init(gtex) \%>\%
  flash_greedy(init_fn = my_init_fn)

# Use a custom initialization function that wraps function nmf from
#   package RcppML.
nmf_init_fn <- function(f) {
  nmf_res <- RcppML::nmf(resid(f), k = 1, verbose = FALSE)
  return(list(as.vector(nmf_res$w), as.vector(nmf_res$h)))
}
fl.nmf <- flash_init(gtex) \%>\%
  flash_greedy(ebnm_fn = ebnm_unimodal_nonnegative,
               init_fn = nmf_init_fn)

}
\seealso{
\code{\link{flash_greedy_init_default}},
  \code{\link{flash_greedy_init_softImpute}},
  \code{\link{flash_greedy_init_irlba}}
}
