% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_greedy_init_fns.R
\name{flash_greedy_init_softImpute}
\alias{flash_greedy_init_softImpute}
\title{Initialize a flash factor using softImpute}
\usage{
flash_greedy_init_softImpute(flash, seed = 666, ...)
}
\arguments{
\item{flash}{A \code{flash_fit} object.}

\item{seed}{Since initialization is random, a default seed is set for
reproducibility.}

\item{...}{Additional parameters to be passed to
\code{\link[softImpute]{softImpute}}.}
}
\value{
A list of length two consisting of, respectively, the vector of
  initial values for loadings \eqn{\ell_{\cdot k}} and the vector of initial
  factor values \eqn{f_{\cdot k}}.
}
\description{
Initializes a new ("greedy") flash factor using \code{\link[softImpute]{softImpute}}.
  When there is missing data, this can yield better results than
  \code{\link{flash_greedy_init_default}} without sacrificing much (if any) speed.
}
\seealso{
\code{\link{flash_greedy}},
  \code{\link{flash_greedy_init_default}},
  \code{\link{flash_greedy_init_irlba}}
}
