% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_transform}
\alias{g_transform}
\title{Apply a coordinate transformation to a WKT geometry}
\usage{
g_transform(wkt, srs_from, srs_to)
}
\arguments{
\item{wkt}{Character. OGC WKT string for a simple feature 2D geometry.}

\item{srs_from}{Character string in OGC WKT format specifying the
spatial reference system for the geometry given by \code{wkt}.}

\item{srs_to}{Character string in OGC WKT format specifying the target
spatial reference system.}
}
\value{
Character string for a transformed OGC WKT geometry.
\code{NA} is returned if GDAL was built without the GEOS library.
}
\description{
\code{g_transform()} will transform the coordinates of a geometry from their
current spatial reference system to a new target spatial reference system.
Normally this means reprojecting the vectors, but it could include datum
shifts, and changes of units.
}
\note{
This function only does reprojection on a point-by-point basis. It does not
include advanced logic to deal with discontinuities at poles or antimeridian.
}
\examples{
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
ds <- new(GDALRaster, elev_file)
ds$bbox() |>
  bbox_to_wkt() |>
  g_transform(ds$getProjectionRef(), epsg_to_wkt(4326)) |>
  bbox_from_wkt()
ds$close()
}
\seealso{
\code{\link[=bbox_from_wkt]{bbox_from_wkt()}}, \code{\link[=bbox_to_wkt]{bbox_to_wkt()}}
}
