% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girafe.R
\name{girafe}
\alias{girafe}
\title{Create a girafe object}
\usage{
girafe(
  code,
  ggobj = NULL,
  pointsize = 12,
  width_svg = NULL,
  height_svg = NULL,
  options = list(),
  dependencies = NULL,
  ...
)
}
\arguments{
\item{code}{Plotting code to execute}

\item{ggobj}{ggplot object to print. Argument \code{code} will
be ignored if this argument is supplied.}

\item{pointsize}{the default pointsize of plotted text in pixels, default to 12.}

\item{width_svg, height_svg}{The width and height of the graphics region in inches.
The default values are 6 and 5 inches. This will define the aspect ratio of the
graphic as it will be used to define viewbox attribute of the SVG result.

If you use \code{girafe()} in an 'R Markdown' document, we
recommend not using these arguments so that the knitr
options \code{fig.width} and \code{fig.height} are used instead.}

\item{options}{a list of options for girafe rendering, see
\code{\link[=opts_tooltip]{opts_tooltip()}}, \code{\link[=opts_hover]{opts_hover()}}, \code{\link[=opts_selection]{opts_selection()}}, ...}

\item{dependencies}{Additional widget HTML dependencies, see \code{\link[htmlwidgets:createWidget]{htmlwidgets::createWidget()}}.}

\item{...}{arguments passed on to \code{\link[=dsvg]{dsvg()}}}
}
\description{
Create an interactive graphic with a ggplot object
to be used in a web browser. The function should replace function
\code{ggiraph}.
}
\details{
Use \code{geom_zzz_interactive} to create interactive graphical elements.

Difference from original functions is that some extra aesthetics are understood:
the \link{interactive_parameters}.

Tooltips can be displayed when mouse is over graphical elements.

If id are associated with points, they get animated when mouse is
over and can be selected when used in shiny apps.

On click actions can be set with javascript instructions. This option
should not be used simultaneously with selections in Shiny
applications as both features are "on click" features.

When a zoom effect is set, "zoom activate", "zoom desactivate" and
"zoom init" buttons are available in a toolbar.

When selection type is set to 'multiple' (in Shiny applications), lasso
selection and lasso anti-selections buttons are available in a toolbar.
}
\section{Widget options}{

girafe animations can be customized with function \code{\link[=girafe_options]{girafe_options()}}.
Options are available to customize tooltips, hover effects, zoom effects
selection effects and toolbar.
}

\section{Widget sizing}{

girafe graphics are responsive, which mean, they will be resized
according to their container. There are two responsive behavior
implementations: one for Shiny applications and flexdashboard documents
and one for other documents (i.e. R markdown and \code{saveWidget}).

Graphics are created by an R graphic device (i.e pdf, png, svg here) and
need arguments width and height to define a graphic region.
Arguments \code{width_svg} and \code{height_svg} are used as corresponding
values. They are defining the aspect ratio of the graphic. This proportion is
always respected when the graph is displayed.

When a girafe graphic is in a Shiny application,
graphic will be resized according to the arguments \code{width} and
\code{height} of the function \code{girafeOutput}. Default
values are '100\\%' and '500px'. These arguments determine the
outer bounding box of the graphic (the HTML element that will
contain the graphic with an aspect ratio).

When a girafe graphic is in an R markdown document (producing an HTML
document), the graphic will be resized according to the argument \code{width} of the
function \code{girafe}. Its value is beeing used to define a relative
width of the graphic within its HTML container. Its height is automatically
adjusted regarding to the argument \code{width} and the aspect ratio.

If this behavior does not fit with your need, I recommend you to use
package widgetframe that wraps htmlwidgets inside a responsive iframe.
}

\examples{
library(ggplot2)

dataset <- mtcars
dataset$carname = row.names(mtcars)

gg_point = ggplot( data = dataset,
    mapping = aes(x = wt, y = qsec, color = disp,
    tooltip = carname, data_id = carname) ) +
  geom_point_interactive() + theme_minimal()

x <- girafe(ggobj = gg_point)

if(interactive()){
  print(x)
}
}
\seealso{
\code{\link[=girafe_options]{girafe_options()}}, \code{\link[=validated_fonts]{validated_fonts()}}, \code{\link[=dsvg]{dsvg()}}
}
