% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggraph.R, R/layout.R, R/tbl_graph.R
\name{ggraph}
\alias{ggraph}
\alias{create_layout}
\alias{layout_ggraph}
\alias{create_layout.default}
\alias{create_layout.layout_ggraph}
\alias{create_layout.tbl_graph}
\alias{layout_tbl_graph}
\title{Create a ggraph plot}
\usage{
ggraph(graph, layout = "auto", ...)

create_layout(graph, layout, circular, ...)

\method{create_layout}{default}(graph, layout, ...)

\method{create_layout}{layout_ggraph}(graph, ...)

\method{create_layout}{tbl_graph}(graph, layout, circular = FALSE, ...)
}
\arguments{
\item{graph}{The object containing the graph. See \emph{Details} for a list
of supported classes. Or a \code{layout_ggraph} object as returned from
\code{create_layout} in which case all subsequent arguments is ignored.}

\item{layout}{The type of layout to create. Either a valid string, a
function, a matrix, or a data.frame (see Details)}

\item{...}{Arguments passed on to the layout function.}

\item{circular}{Should the layout be transformed into a radial
representation. Only possible for some layouts. Defaults to \code{FALSE}}
}
\value{
For \code{ggraph()} an object of class gg onto which layers, scales,
etc. can be added. For \code{create_layout()} an object inheriting from
\code{layout_ggraph}. \code{layout_ggraph} itself inherits from
\code{data.frame} and can be considered as such. The data.frame contains
the node positions in the \code{x} and \code{y} column along with
additional columns generated by the specific layout, as well as node
parameters inherited from the graph. Additional information is stored as
attributes to the data.frame. The original graph object is stored in the
\code{graph} attribute and the \code{circular} attribute contains a logical
indicating whether the layout has been transformed to a circular
representation.
}
\description{
This function is the equivalent of \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} in ggplot2.
It takes care of setting up the plot object along with creating the layout
for the plot based on the graph and the specification passed in.
Alternatively a layout can be prepared in advance using
\code{create_layout} and passed as the data argument. See \emph{Details} for
a description of all available layouts.
}
\details{
Following is a short description of the different layout types available in
ggraph. Each layout is further described in its own help pages. Any type of
regular graph/network data can be represented as a tbl_graph object. Because
of this the different layouts that can be applied to tbl_graph
objects are quite diverse, but not all layouts makes sense to all types of
graphs. It is up to the user to understand their data and choose an
appropriate layout. For standard node-edge diagrams igraph defines a
long range of different layout functions that are all available through the
\code{igraph} layout where the specific layout is specified using the
\code{algorithm} argument. In order to minimize typing all igraph algorithms
can also be passed directly into the \code{layout} argument.

Any object that has an appropriate \code{as_tbl_graph} method can be passed
into \code{ggraph()} and will automatically be converted underneath.

\describe{
\item{\code{auto}}{The default layout. See \code{\link[=layout_tbl_graph_auto]{layout_tbl_graph_auto()}} for further
details}
\item{\code{igraph}}{Use one of the internal igraph layout algorithms.
The algorithm is specified using the \code{algorithm} argument. All strings
accepted by the \code{algorithm} argument can also be supplied directly
into \code{layout}. See \code{\link[=layout_tbl_graph_igraph]{layout_tbl_graph_igraph()}} for further
details}
\item{\code{dendrogram}}{Lays out the nodes in a tree-like graph as a
dendrogram with leaves set at 0 and parents 1 unit above its tallest child.
See \code{\link[=layout_tbl_graph_dendrogram]{layout_tbl_graph_dendrogram()}} for further details}
\item{\code{manual}}{Lets the user manually specify the location of each
node. See \code{\link[=layout_tbl_graph_manual]{layout_tbl_graph_manual()}} for further details}
\item{\code{linear}}{Arranges the nodes linearly or circularly in order to
make an arc diagram. See \code{\link[=layout_tbl_graph_linear]{layout_tbl_graph_linear()}} for further
details}
\item{\code{matrix}}{Arranges nodes on a diagonal thus preparing it for use with
\code{\link[=geom_edge_point]{geom_edge_point()}} to make a matrix plot. See \code{\link[=layout_tbl_graph_matrix]{layout_tbl_graph_matrix()}}
for further details}
\item{\code{treemap}}{Creates a treemap from the graph, that is, a
space-filing subdivision of rectangles showing a weighted hierarchy. See
\code{\link[=layout_tbl_graph_treemap]{layout_tbl_graph_treemap()}} for further details}
\item{\code{circlepack}}{Creates a layout showing a hierarchy as circles
within circles. Conceptually equal to treemaps. See
\code{\link[=layout_tbl_graph_circlepack]{layout_tbl_graph_circlepack()}} for further details}
\item{\code{partition}}{Create icicle or sunburst charts, where each layer
subdivides the division given by the preceding layer. See
\code{\link[=layout_tbl_graph_partition]{layout_tbl_graph_partition()}} for further details}
\item{\code{hive}}{Positions nodes on axes spreading out from the center
based on node attributes. See \code{\link[=layout_tbl_graph_hive]{layout_tbl_graph_hive()}} for further
details}
\item{\code{cactustree}}{Positions nodes as circles on the periphery of their
parent circle. See \code{\link[=layout_tbl_graph_cactustree]{layout_tbl_graph_cactustree()}} for further
details}
\item{\code{backbone}}{Layout optimised for highly connected small-world graphs
such as social networks. See \code{\link[=layout_tbl_graph_backbone]{layout_tbl_graph_backbone()}} for further
details}
\item{\code{centrality}}{Place nodes around origin based on their centrality.
See \code{\link[=layout_tbl_graph_centrality]{layout_tbl_graph_centrality()}} for further
details}
\item{\code{eigen}}{Spectral layout based on the eigenvector of a matrix
representation of the graph. See \code{\link[=layout_tbl_graph_eigen]{layout_tbl_graph_eigen()}} for further
details}
\item{\code{fabric}}{Draw nodes as horizontal lines and connect them with
vertical lines if an edge exists between them. See
\code{\link[=layout_tbl_graph_fabric]{layout_tbl_graph_fabric()}} for further
details}
\item{\code{focus}}{Place nodes around a focus node based on their distance to
that node. See \code{\link[=layout_tbl_graph_focus]{layout_tbl_graph_focus()}} for further
details}
\item{\code{pmds}}{Layout based on multidimensional scaling of a set of pivot
nodes, allowing MDS layout to be used on larger graphs. See
\code{\link[=layout_tbl_graph_pmds]{layout_tbl_graph_pmds()}} for further
details}
\item{\code{stress}}{Layout based on stress minimisation with better stability
than Kamada-Kawai layout. See \code{\link[=layout_tbl_graph_stress]{layout_tbl_graph_stress()}} for further
details}
\item{\code{unrooted}}{Draws unrooted trees based on equal angle with optional
equal daylight modification. See \code{\link[=layout_tbl_graph_unrooted]{layout_tbl_graph_unrooted()}} for further
details}
\item{\code{htree}}{Draws binary trees as a space filling fractal. See
\code{\link[=layout_tbl_graph_htree]{layout_tbl_graph_htree()}} for further details}
}

Alternatively a matrix or a data.frame can be provided to the \code{layout}
argument. In the former case the first column will be used as x coordinates
and the second column will by used as y coordinates, further columns are
dropped. In the latter case the data.frame is used as the layout table and
must thus contain a numeric x and y column.

Lastly a function can be provided to the \code{layout} argument. It will be called
with the graph object as its first argument and any additional argument
passed into \code{ggraph()}/\code{create_layout()}. The function must return either a
data.frame or an object coercible to one and have an \code{x} and \code{y} column, or
an object coercible to a \code{tbl_graph}. In the latter case the node data is
extracted and used as layout (and must thus contain an \code{x} and \code{y} column)
and the graph will be added as the \code{graph} attribute.
}
\examples{
require(tidygraph)
gr <- create_notable('bull')
layout <- create_layout(gr, layout = 'igraph', algorithm = 'kk')
}
\seealso{
\code{\link[=get_edges]{get_edges()}} for extracting edge information from the
layout and \code{\link[=get_con]{get_con()}} for extracting path information.
}
\keyword{graph}
\keyword{hierarchy}
\keyword{layout}
\keyword{network}
\keyword{visualisation}
