% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.R
\name{\%<+\%}
\alias{\%<+\%}
\title{\%<+\%}
\usage{
pg \%<+\% data
}
\arguments{
\item{pg}{ggplot2 object}

\item{data}{annotation data that contains a column of “node” , or the first column of taxa labels}
}
\value{
ggplot object with annotation data added
}
\description{
add annotation data to a tree
}
\details{
This operator attaches annotation data to a ggtree graphic object
}
\examples{
nwk <- system.file("extdata", "sample.nwk", package="treeio")
tree <- read.tree(nwk)
p <- ggtree(tree)
dd <- data.frame(taxa=LETTERS[1:13],
   		 place=c(rep("GZ", 5), rep("HK", 3), rep("CZ", 4), NA),
             value=round(abs(rnorm(13, mean=70, sd=10)), digits=1))
row.names(dd) <- NULL
p \%<+\% dd + geom_text(aes(color=place, label=label), hjust=-0.5)
}
\references{
G Yu, TTY Lam, H Zhu, Y Guan (2018). Two methods for mapping and visualizing associated data
on phylogeny using ggtree. Molecular Biology and Evolution, 35(2):3041-3043.
\url{https://doi.org/10.1093/molbev/msy194}
}
\seealso{
geom_facet
}
\author{
Guangchuang Yu
}
