% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_nodelab.R
\name{geom_nodelab}
\alias{geom_nodelab}
\title{geom_nodelab}
\usage{
geom_nodelab(
  mapping = NULL,
  nudge_x = 0,
  nudge_y = 0,
  geom = "text",
  hjust = 0.5,
  node = "internal",
  ...
)
}
\arguments{
\item{mapping}{aesthetic mappings, defaults to NULL}

\item{nudge_x}{horizontal adjustment to nudge labels, defaults to 0}

\item{nudge_y}{vertical adjustment to nudge labels, defaults to 0}

\item{geom}{one of 'text', "shadowtext", 'label', 'image' and 'phylopic'}

\item{hjust}{horizontal alignment, defaults to 0.5}

\item{node}{a character indicating which node labels will be displayed,
it should be one of 'internal', 'external' and 'all'. If it is set to 'internal'
will display internal node labels, 'external' will display the tip labels,
and 'all' will display internal node and tip labels.}

\item{...}{additional parameters, see also
the additional parameters of \code{\link[=geom_tiplab]{geom_tiplab()}}.}
}
\value{
geom layer
}
\description{
add node label layer for a tree
}
\references{
For demonstration of this function, please refer to chapter A.4.5 of
\emph{Data Integration, Manipulation and Visualization of Phylogenetic Trees}
\url{http://yulab-smu.top/treedata-book/index.html} by Guangchuang Yu.
}
\seealso{
\code{\link[=geom_tiplab]{geom_tiplab()}}
}
\author{
Guangchuang Yu
}
