% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_taxalink.R
\name{geom_taxalink}
\alias{geom_taxalink}
\title{link between taxa}
\usage{
geom_taxalink(
  data = NULL,
  mapping = NULL,
  taxa1 = NULL,
  taxa2 = NULL,
  offset = NULL,
  outward = "auto",
  ...
)
}
\arguments{
\item{data}{data.frame, The data to be displayed in this layer, default is NULL.}

\item{mapping}{Set of aesthetic mappings, default is NULL.}

\item{taxa1}{can be label or node number.}

\item{taxa2}{can be label or node number.}

\item{offset}{numeric, control the shift of curve line (the ratio of axis value,
range is "(0-1)"), default is NULL.}

\item{outward}{logical, control the orientation of curve when the layout of tree is circular,
fan or other layout in polar coordinate, default is "auto", meaning It will automatically.}

\item{..., }{additional parameter.}
}
\value{
a list object.
}
\description{
\code{geom_taxalink} supports data.frame as input,
the \code{colour}, \code{linewidth}, \code{linetype} and \code{alpha} can be mapped. When the \code{data} was provided,
the \code{mapping} should be also provided, which \code{taxa1} and \code{taxa2} should be mapped created
by \code{aes}, \code{aes_} or \code{aes_string}. In addition, the \code{hratio}, control the height of curve line,
when tree layout is \code{cirular}, default is 1. \code{ncp}, the number of control points used to draw the
curve, more control points creates a smoother curve, default is 1. They also can be mapped to
a column of data.
}
\section{Aesthetics}{

\code{geom_taxalink()} understands the following aesthethics (required aesthetics are in bold):
\itemize{
\item \strong{\code{taxa1}} label or node number of tree.
\item \strong{\code{taxa2}} label or node number of tree.
\item \code{group} group category of link.
\item \code{colour} control the color of line, default is black.
\item \code{linetype} control the type of line, default is 1 (solid).
\item \code{linewidth} control the width of line, default is 0.5.
\item \code{curvature} control the curvature of line, default is 0.5,
it will be created automatically in polar coordinate .
\item \code{hratio} control the height of curve line, default is 1.
\item \code{ncp} control the smooth of curve line, default is 1.
}
}

