% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{gcs_delete_object}
\alias{gcs_delete_object}
\title{Delete an object}
\usage{
gcs_delete_object(
  object_name,
  bucket = gcs_get_global_bucket(),
  generation = NULL
)
}
\arguments{
\item{object_name}{Object to be deleted, or a \code{gs://} URL}

\item{bucket}{Bucket to delete object from}

\item{generation}{If present, deletes a specific version.

Default if \code{generation} is NULL is to delete the latest version.}
}
\value{
If successful, TRUE.
}
\description{
Deletes an object from a bucket
}
\seealso{
To delete all objects in a bucket see \link{gcs_delete_bucket_objects}

Other object functions: 
\code{\link{gcs_compose_objects}()},
\code{\link{gcs_copy_object}()},
\code{\link{gcs_get_object}()},
\code{\link{gcs_list_objects}()},
\code{\link{gcs_metadata_object}()}
}
\concept{object functions}
