% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.Dataset.R
\name{gpb.Dataset}
\alias{gpb.Dataset}
\title{Construct \code{gpb.Dataset} object}
\usage{
gpb.Dataset(data, params = list(), reference = NULL, colnames = NULL,
  categorical_feature = NULL, free_raw_data = FALSE, info = list(), ...)
}
\arguments{
\item{data}{a \code{matrix} object, a \code{dgCMatrix} object or a character representing a filename}

\item{params}{a list of parameters. See
\href{https://github.com/fabsig/GPBoost/blob/master/docs/Parameters.rst#dataset-parameters}{
the "Dataset Parameters" section of the parameter documentation} for a list of parameters
and valid values.}

\item{reference}{reference dataset. When GPBoost creates a Dataset, it does some preprocessing like binning
continuous features into histograms. If you want to apply the same bin boundaries from an existing
dataset to new \code{data}, pass that existing Dataset to this argument.}

\item{colnames}{names of columns}

\item{categorical_feature}{categorical features. This can either be a character vector of feature
names or an integer vector with the indices of the features (e.g.
\code{c(1L, 10L)} to say "the first and tenth columns").}

\item{free_raw_data}{GPBoost constructs its data format, called a "Dataset", from tabular data.
By default, this Dataset object on the R side does keep a copy of the raw data.
If you set \code{free_raw_data = TRUE}, no copy of the raw data is kept (this reduces memory usage)}

\item{info}{a list of information of the \code{gpb.Dataset} object}

\item{...}{other information to pass to \code{info} or parameters pass to \code{params}}
}
\value{
constructed dataset
}
\description{
Construct \code{gpb.Dataset} object from dense matrix, sparse matrix
             or local file (that was created previously by saving an \code{gpb.Dataset}).
}
\examples{
\donttest{
data(agaricus.train, package = "gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)
data_file <- tempfile(fileext = ".data")
gpb.Dataset.save(dtrain, data_file)
dtrain <- gpb.Dataset(data_file)
gpb.Dataset.construct(dtrain)
}
}
