% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medfilt1.R
\name{medfilt1}
\alias{medfilt1}
\title{1-D median filtering}
\usage{
medfilt1(x, n = 3, MARGIN = 2, na.omit = FALSE, ...)
}
\arguments{
\item{x}{Input signal, specified as a numeric vector, matrix or array.}

\item{n}{positive integer width of the median window; must be odd. Default: 3}

\item{MARGIN}{Vector giving the subscripts which the function will be applied
over. E.g., for a matrix 1 indicates rows, 2 indicates columns, c(1, 2)
indicates rows and columns. Where X has named dimnames, it can be a
character vector selecting dimension names. Default: 2 (columns).}

\item{na.omit}{logical indicating whether to omit missing values,
or interpolate then using a cubic spline function
(\code{\link[stats]{splinefun}}). Default: FALSE}

\item{...}{other arguments passed to \code{runmed}}
}
\value{
Filtered signal, returned as a numeric vector, matrix, or array, of
  the same size as \code{x}.
}
\description{
Apply a running median of odd span to the input \code{x}
}
\details{
This function computes a running median over the input \code{x}, using the
\code{\link[stats]{runmed}} function. Because of that, it works a little
differently than the 'Matlab' or 'Octave' versions (i.e., it does not produce
exactly the same values).

\describe{
\item{missing values}{The 'Mablab' and 'Octave' functions have a
\code{'nanflag'} option that allows to include or remove missing values. If
inclusion is specifies, then the function returns a signal so that the median
of any segment containing NAs is also NA. Because the \code{'runmed'} function
does not include an \code{na.omit} option, implementing this functionality
would lead to a considerable speed loss. Instead, a \code{na.omit} parameter
was implemented that allows either omitting NAs or interpolating them with a
spline function.}
\item{endpoint filtering}{Instead of the \code{'zeropad'} and
\code{'truncate'} options to the \code{'padding'} argument in the 'Matlab'
and 'Octave' functions, the present version uses the standard
\code{endrule} parameter of the \code{'runmed'} function, with options
\code{keep}, \code{constant}, or \code{median}.}
}
}
\examples{
## noise suppression
fs <- 100
t <- seq(0, 1, 1/fs)
x <- sin(2 * pi * t * 3) + 0.25 * sin(2 * pi * t * 40)
plot(t, x, type = "l", xlab = "", ylab = "")
y <- medfilt1(x, 11)
lines (t, y, col = "red")
legend("topright", c("Original", "Filtered"), lty = 1, col = 1:2)

}
\seealso{
\code{\link[stats]{runmed}}, \code{\link[stats]{splinefun}}
}
\author{
Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
