% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flattopwin.R
\name{flattopwin}
\alias{flattopwin}
\title{Flat top window}
\usage{
flattopwin(n, method = c("symmetric", "periodic"))
}
\arguments{
\item{n}{Window length, specified as a positive integer.}

\item{method}{Character string. Window sampling method, specified as:
\describe{
  \item{"symmetric"}{(Default). Use this option when using windows for filter
  design.}
  \item{"periodic"}{This option is useful for spectral analysis because it
  enables a windowed signal to have the perfect periodic extension implicit
  in the discrete Fourier transform. When 'periodic' is specified, the
  function computes a window of length \code{n + 1} and returns the first
  \code{n} points.}
}}
}
\value{
Flat top window, returned as a vector.
}
\description{
Return the filter coefficients of a flat top window.
}
\details{
The Flat Top window is defined by the function:
\deqn{f(w) = 1 - 1.93 cos(2 \pi w) + 1.29 cos(4 \pi w) - 0.388 cos(6 \pi w) +
0.0322 cos(8 \pi w)}
where \code{w = i/(n-1)} for \code{i=0:n-1} for a symmetric window, or
\code{w = i/n} for \code{i=0:n-1} for a periodic window. The default is
symmetric. The returned window is normalized to a peak of 1 at w = 0.5.

Flat top windows have very low passband ripple (< 0.01 dB) and are used
primarily for calibration purposes. Their bandwidth is approximately 2.5
times wider than a Hann window.
}
\examples{

ft <- flattopwin(64)
plot (ft, type = "l", xlab = "Samples", ylab =" Amplitude")


}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
