% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_cmdstan_path.R
\name{stan_cmdstan_path}
\alias{stan_cmdstan_path}
\title{Path to CmdStan for \code{instantiate}}
\usage{
stan_cmdstan_path(cmdstan_install = Sys.getenv("CMDSTAN_INSTALL", unset = ""))
}
\arguments{
\item{cmdstan_install}{Character of length 1, how to look for an installed
copy of CmdStan. See \url{https://wlandau.github.io/instantiate/} for details.
Choices:
\enumerate{
\item \code{""} (default): look at the original value that the \code{CMDSTAN_INSTALL}
environment variable contained when \code{instantiate} at the time
when it was installed.
If it was \code{"implicit"} or \code{"fixed"}, then choose
the corresponding option below. Otherwise, default to \code{"implicit"}.
\item \code{"implicit"}: Let the \code{cmdstanr::cmdstan_path()} decide where
to look for CmdStan. As explained in the \code{cmdstanr} documentation,
the output of \code{cmdstanr::cmdstan_path()} depends
on the current value of the \code{CMDSTAN} environment variable.
The \code{cmdstanr} package must be installed. If it
is not installed, then \code{stan_cmdstan_path()}
returns the empty string \code{""}.
\item \code{"fixed"}: Use the path to CmdStan that was originally
contained in \code{Sys.getenv("CMDSTAN")} at the time when \code{instantiate}
was installed.
}}
}
\value{
Character of length 1, directory path to CmdStan. The path
may or may not exist. Returns the empty string \code{""} if the path
cannot be determined.
}
\description{
Return the directory path to CmdStan that the \code{instantiate}
package uses.
}
\examples{
stan_cmdstan_path()
}
\seealso{
Other packages: 
\code{\link{stan_package_clean}()},
\code{\link{stan_package_compile}()},
\code{\link{stan_package_configure}()},
\code{\link{stan_package_model_files}()}
}
\concept{packages}
