% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icompress.R
\name{i_mask}
\alias{i_mask}
\title{Iterator that filters elements where corresponding selector is false.}
\usage{
i_mask(object, selectors)
}
\arguments{
\item{object}{an iterable object}

\item{selectors}{an iterable that determines whether the corresponding
element in \code{object} is returned.}
}
\value{
iterator object
}
\description{
Constructs an iterator that filters elements from iterable returning only
those for which the corresponding element from \code{selectors} is
\code{TRUE}.
}
\details{
The iterator stops when either \code{object} or \code{selectors} has been
exhausted.
}
\examples{
# Filters out odd numbers and retains only even numbers
n <- 10
selectors <- rep(c(FALSE, TRUE), n)
it <- i_mask(seq_len(n), selectors)
as.list(it)

# Similar idea here but anonymous function is used to filter out even
# numbers
n <- 10
it2 <- i_mask(seq_len(10), rep(c(TRUE, FALSE), n))
as.list(it2)

it3 <- i_mask(letters, letters \%in\% c('a', 'e', 'i', 'o', 'u'))
as.list(it3)
}
