% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7.dph.R
\name{fit,dph-method}
\alias{fit,dph-method}
\title{Fit method for dph class}
\usage{
\S4method{fit}{dph}(x, y, weight = numeric(0), stepsEM = 1000, every = 100)
}
\arguments{
\item{x}{An object of class \linkS4class{dph}.}

\item{y}{Vector or data.}

\item{weight}{Vector of weights.}

\item{stepsEM}{Number of EM steps to be performed.}

\item{every}{Number of iterations between likelihood display updates.}
}
\value{
An object of class \linkS4class{dph}.
}
\description{
Fit method for dph class
}
\examples{
obj <- dph(structure = "general", dimension = 2)
data <- sim(obj, n = 100)
fit(obj, data, stepsEM = 100, every = 20)
}
