% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.phMoE.R
\name{MoE,ph-method}
\alias{MoE,ph-method}
\title{MoE method for ph Class}
\usage{
\S4method{MoE}{ph}(
  x,
  formula,
  data,
  inhom = NULL,
  alpha_vecs = NULL,
  weight = numeric(0),
  delta = numeric(0),
  stepsEM = 1000,
  optim_method = "BFGS",
  maxit = 50,
  reltol = 1e-08,
  every = 10,
  rand_init = TRUE
)
}
\arguments{
\item{x}{An object of class \linkS4class{ph}.}

\item{formula}{A regression formula.}

\item{data}{A data frame.}

\item{inhom}{A list with the inhomogeneity functions.}

\item{alpha_vecs}{Matrix of initial probabilities.s}

\item{weight}{Vector of weights.}

\item{delta}{Right-censoring indicator.}

\item{stepsEM}{Number of EM steps to be performed.}

\item{optim_method}{Method to use in gradient optimization.}

\item{maxit}{Maximum number of iterations when optimizing g function.}

\item{reltol}{Relative tolerance when optimizing g function.}

\item{every}{Number of iterations between likelihood display updates.}

\item{rand_init}{Random initiation in the R-step.}
}
\value{
An object of class \linkS4class{sph}.
}
\description{
MoE method for ph Class
}
\examples{
x <- iph(ph(structure = "general"), gfun = "weibull")
n <- 100
responses <- rweibull(n, 2, 3)
covariate <- data.frame(age = sample(18:65, n, replace = TRUE) / 100, income = runif(n, 0, 0.99))
f <- responses ~ age + income # regression formula
MoE(x = x, formula = f, y = responses, data = covariate, stepsEM = 20)
}
