% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4b.bivph.R
\name{fit,bivph-method}
\alias{fit,bivph-method}
\title{Fit method for bivph Class}
\usage{
\S4method{fit}{bivph}(
  x,
  y,
  weight = numeric(0),
  stepsEM = 1000,
  maxit = 100,
  reltol = 1e-08,
  every = 10
)
}
\arguments{
\item{x}{An object of class \linkS4class{bivph}.}

\item{y}{A matrix with the data.}

\item{weight}{Vector of weights.}

\item{stepsEM}{Number of EM steps to be performed.}

\item{maxit}{Maximum number of iterations when optimizing g functions.}

\item{reltol}{Relative tolerance when optimizing g functions.}

\item{every}{Number of iterations between likelihood display updates.}
}
\value{
An object of class \linkS4class{bivph}.
}
\description{
Fit method for bivph Class
}
\examples{
obj <- bivph(dimensions = c(3, 3))
data <- sim(obj, n = 100)
fit(obj, data, stepsEM = 100, every = 50)
}
