% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objective.R
\name{Objective}
\alias{Objective}
\title{Specify objective function}
\value{
An \code{Objective} object.
}
\description{
The \code{Objective} object specifies the framework for an objective function
for numerical optimization.
}
\examples{
### define log-likelihood function of Gaussian mixture model
llk <- function(mu, sd, lambda, data){
  sd <- exp(sd)
  lambda <- plogis(lambda)
  sum(log(lambda * dnorm(data, mu[1], sd[1]) + (1 - lambda) * dnorm(data, mu[2], sd[2])))
}

### the log-likelihood function is supposed to be optimized over the first
### three arguments, the 'data' argument is constant
objective <- Objective$new(
  objective = llk, target = c("mu", "sd", "lambda"), npar = c(2, 2, 1),
  data = faithful$eruptions
)

### evaluate the objective function at 1:5 (1:2 is passed to mu, 3:4 to sd,
### and 5 to lambda)
objective$evaluate(1:5)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{objective_name}}{A \code{character}, a label for the objective function.}

\item{\code{seconds}}{A \code{numeric}, a time limit in seconds. Computations are interrupted
prematurely if \code{seconds} is exceeded.

No time limit if \code{seconds = Inf} (the default).

Note the limitations documented in \code{\link[base]{setTimeLimit}}.}

\item{\code{hide_warnings}}{Either \code{TRUE} to hide warnings when evaluating the objective function,
or \code{FALSE} (default) if not.}

\item{\code{verbose}}{Either \code{TRUE} (default) to print status messages, or \code{FALSE}
to hide those.}

\item{\code{npar}}{An \code{integer} vector, defining the length of each target argument.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Objective-new}{\code{Objective$new()}}
\item \href{#method-Objective-set_argument}{\code{Objective$set_argument()}}
\item \href{#method-Objective-get_argument}{\code{Objective$get_argument()}}
\item \href{#method-Objective-remove_argument}{\code{Objective$remove_argument()}}
\item \href{#method-Objective-validate}{\code{Objective$validate()}}
\item \href{#method-Objective-evaluate}{\code{Objective$evaluate()}}
\item \href{#method-Objective-print}{\code{Objective$print()}}
\item \href{#method-Objective-clone}{\code{Objective$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Objective-new"></a>}}
\if{latex}{\out{\hypertarget{method-Objective-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{Objective} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Objective$new(objective, target, npar, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{objective}}{A \code{function} to be optimized that
\enumerate{
\item has at least one argument that receives a \code{numeric} \code{vector}
\item and returns a single \code{numeric} value.
}}

\item{\code{target}}{A \code{character}, the argument names of \code{objective} that get
optimized. These arguments must receive a \code{numeric} \code{vector}.}

\item{\code{npar}}{A \code{integer} of the same length as \code{target}, defining the length
of the respective \code{numeric} \code{vector} argument.}

\item{\code{...}}{Optionally additional arguments to \code{objective} that are fixed during
the optimization.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Objective} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Objective-set_argument"></a>}}
\if{latex}{\out{\hypertarget{method-Objective-set_argument}{}}}
\subsection{Method \code{set_argument()}}{
Set a fixed function argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Objective$set_argument(..., overwrite = TRUE, verbose = self$verbose)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optionally additional arguments to \code{objective} that are fixed during
the optimization.}

\item{\code{overwrite}}{Either \code{TRUE} (default) to allow overwriting, or \code{FALSE} if not.}

\item{\code{verbose}}{Either \code{TRUE} (default) to print status messages, or \code{FALSE}
to hide those.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly the \code{Objective} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Objective-get_argument"></a>}}
\if{latex}{\out{\hypertarget{method-Objective-get_argument}{}}}
\subsection{Method \code{get_argument()}}{
Get a fixed function argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Objective$get_argument(argument_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{argument_name}}{A \code{character}, a name of an argument for \code{objective}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The argument value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Objective-remove_argument"></a>}}
\if{latex}{\out{\hypertarget{method-Objective-remove_argument}{}}}
\subsection{Method \code{remove_argument()}}{
Remove a fixed function argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Objective$remove_argument(argument_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{argument_name}}{A \code{character}, a name of an argument for \code{objective}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly the \code{Objective} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Objective-validate"></a>}}
\if{latex}{\out{\hypertarget{method-Objective-validate}{}}}
\subsection{Method \code{validate()}}{
Validate an \code{Objective} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Objective$validate(.at)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{.at}}{A \code{numeric} of length \code{sum(self$npar)}, the values for the target
arguments written in a single vector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly the \code{Objective} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Objective-evaluate"></a>}}
\if{latex}{\out{\hypertarget{method-Objective-evaluate}{}}}
\subsection{Method \code{evaluate()}}{
Evaluate the objective function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Objective$evaluate(.at, .negate = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{.at}}{A \code{numeric} of length \code{sum(self$npar)}, the values for the target
arguments written in a single vector.}

\item{\code{.negate}}{Either \code{TRUE} to negate the \code{numeric} return value of
\code{objective}, or \code{FALSE} (default) else.}

\item{\code{...}}{Optionally additional arguments to \code{objective} that are fixed during
the optimization.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The objective value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Objective-print"></a>}}
\if{latex}{\out{\hypertarget{method-Objective-print}{}}}
\subsection{Method \code{print()}}{
Print details of the \code{Objective} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Objective$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Invisibly the \code{Objective} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Objective-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Objective-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Objective$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
