% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.cv_proportions}
\alias{plot.cv_proportions}
\alias{plot.ranking}
\title{Plot ranking proportions from fold-wise predictor rankings}
\usage{
\method{plot}{cv_proportions}(x, text_angle = NULL, ...)

\method{plot}{ranking}(x, ...)
}
\arguments{
\item{x}{For \code{\link[=plot.cv_proportions]{plot.cv_proportions()}}: an object of class \code{cv_proportions}
(returned by \code{\link[=cv_proportions]{cv_proportions()}}, possibly with \code{cumulate = TRUE}). For
\code{\link[=plot.ranking]{plot.ranking()}}: an object of class \code{ranking} (returned by \code{\link[=ranking]{ranking()}})
that \code{\link[=cv_proportions]{cv_proportions()}} will be applied to internally before then calling
\code{\link[=plot.cv_proportions]{plot.cv_proportions()}}.}

\item{text_angle}{Passed to argument \code{angle} of \code{\link[ggplot2:element]{ggplot2::element_text()}} for
the y-axis tick labels. In case of long predictor names, \code{text_angle = 45}
might be helpful (for example).}

\item{...}{For \code{\link[=plot.ranking]{plot.ranking()}}: arguments passed to
\code{\link[=cv_proportions.ranking]{cv_proportions.ranking()}} and \code{\link[=plot.cv_proportions]{plot.cv_proportions()}}. For
\code{\link[=plot.cv_proportions]{plot.cv_proportions()}}: currently ignored.}
}
\value{
A \pkg{ggplot2} plotting object (of class \code{gg} and \code{ggplot}).
}
\description{
Plots the ranking proportions (see \code{\link[=cv_proportions]{cv_proportions()}}) from the fold-wise
predictor rankings in a cross-validation with fold-wise searches. This is a
visualization of the \emph{transposed} matrix returned by \code{\link[=cv_proportions]{cv_proportions()}}. The
proportions printed as text inside of the colored tiles are rounded to whole
percentage points (the plotted proportions themselves are not rounded).
}
\examples{
\dontshow{if (identical(Sys.getenv("RUN_EX"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Note: The code from this example is not executed when called via example().
# To execute it, you have to copy and paste it manually to the console.
if (requireNamespace("rstanarm", quietly = TRUE)) {
  # Data:
  dat_gauss <- data.frame(y = df_gaussian$y, df_gaussian$x)

  # The "stanreg" fit which will be used as the reference model (with small
  # values for `chains` and `iter`, but only for technical reasons in this
  # example; this is not recommended in general):
  fit <- rstanarm::stan_glm(
    y ~ X1 + X2 + X3 + X4 + X5, family = gaussian(), data = dat_gauss,
    QR = TRUE, chains = 2, iter = 1000, refresh = 0, seed = 9876
  )

  # Run cv_varsel() (with small values for `K`, `nterms_max`, `nclusters`,
  # and `nclusters_pred`, but only for the sake of speed in this example;
  # this is not recommended in general):
  cvvs <- cv_varsel(fit, cv_method = "kfold", K = 2, nterms_max = 3,
                    nclusters = 5, nclusters_pred = 10, seed = 5555)

  # Extract predictor rankings:
  rk <- ranking(cvvs)

  # Compute ranking proportions:
  pr_rk <- cv_proportions(rk)

  # Visualize the ranking proportions:
  gg_pr_rk <- plot(pr_rk)
  print(gg_pr_rk)

  # Since the object returned by plot.cv_proportions() is a standard ggplot2
  # plotting object, you can modify the plot easily, e.g., to remove the
  # legend:
  print(gg_pr_rk + theme(legend.position = "none"))
}
\dontshow{\}) # examplesIf}
}
\author{
Idea and original code by Aki Vehtari. Slight modifications of the
original code by Frank Weber, Yann McLatchie, and Sölvi Rögnvaldsson. Final
implementation in \pkg{projpred} by Frank Weber.
}
