% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psfmi_coxr.R
\name{psfmi_coxr}
\alias{psfmi_coxr}
\title{Pooling and Predictor selection function for backward or forward selection of
Cox regression models across multiply imputed data.}
\usage{
psfmi_coxr(
  data,
  formula = NULL,
  nimp = 5,
  impvar = NULL,
  status = NULL,
  time = NULL,
  predictors = NULL,
  cat.predictors = NULL,
  spline.predictors = NULL,
  int.predictors = NULL,
  keep.predictors = NULL,
  nknots = NULL,
  p.crit = 1,
  method = "RR",
  direction = NULL
)
}
\arguments{
\item{data}{Data frame with stacked multiple imputed datasets.
The original dataset that contains missing values must be excluded from the
dataset. The imputed datasets must be distinguished by an imputation variable,
specified under impvar, and starting by 1.}

\item{formula}{A formula object to specify the model as normally used by coxph.
See under "Details" and "Examples" how these can be specified. If a formula
object is used set predictors, cat.predictors, spline.predictors or int.predictors
at the default value of NULL.}

\item{nimp}{A numerical scalar. Number of imputed datasets. Default is 5.}

\item{impvar}{A character vector. Name of the variable that distinguishes the
imputed datasets.}

\item{status}{The status variable, normally 0=censoring, 1=event.}

\item{time}{Survival time.}

\item{predictors}{Character vector with the names of the predictor variables.
At least one predictor variable has to be defined. Give predictors unique names
and do not use predictor name combinations with numbers as, age2, gnder10, etc.}

\item{cat.predictors}{A single string or a vector of strings to define the
categorical variables. Default is NULL categorical predictors.}

\item{spline.predictors}{A single string or a vector of strings to define the
(restricted cubic) spline variables. Default is NULL spline predictors. See details.}

\item{int.predictors}{A single string or a vector of strings with the names of the variables that form
an interaction pair, separated by a “:” symbol.}

\item{keep.predictors}{A single string or a vector of strings including the variables that are forced
in the model during predictor selection. Categorical and interaction variables are allowed.}

\item{nknots}{A numerical vector that defines the number of knots for each spline predictor separately.}

\item{p.crit}{A numerical scalar. P-value selection criterion. A value of 1
provides the pooled model without selection.}

\item{method}{A character vector to indicate the pooling method for p-values to pool the
total model or used during predictor selection. This can be "RR", D1", "D2", or "MPR".
See details for more information. Default is "RR".}

\item{direction}{The direction of predictor selection, "BW" means backward selection and "FW"
means forward selection.}
}
\value{
An object of class \code{pmods} (multiply imputed models) from
 which the following objects can be extracted: 
 \itemize{
 \item  \code{data} imputed datasets
 \item  \code{RR_model} pooled model at each selection step
 \item  \code{RR_model_final} final selected pooled model
 \item  \code{multiparm} pooled p-values at each step according to pooling method
 \item  \code{multiparm_final} pooled p-values at final step according to pooling method
 \item  \code{multiparm_out} (only when direction = "FW") pooled p-values of removed predictors 
 \item  \code{formula_step} formula object at each step
 \item  \code{formula_final} formula object at final step
 \item  \code{formula_initial} formula object at final step
 \item  \code{predictors_in} predictors included at each selection step
 \item  \code{predictors_out} predictors excluded at each step
 \item  \code{impvar} name of variable used to distinguish imputed datasets
 \item  \code{nimp} number of imputed datasets
 \item  \code{status} name of the status variable
 \item  \code{time} name of the time variable
 \item  \code{method} selection method
 \item  \code{p.crit} p-value selection criterium
 \item  \code{call} function call
 \item  \code{model_type} type of regression model used
 \item  \code{direction} direction of predictor selection
 \item  \code{predictors_final} names of predictors in final selection step
 \item  \code{predictors_initial} names of predictors in start model
 \item  \code{keep.predictors} names of predictors that were forced in the model    
}
}
\description{
\code{psfmi_coxr} Pooling and backward or forward selection of Cox regression
prediction models in multiply imputed data using selection methods D1, D2 and MPR.
}
\details{
The basic pooling procedure to derive pooled coefficients, standard errors, 95
 confidence intervals and p-values is Rubin's Rules (RR). However, RR is only possible when
 the model included continuous or dichotomous variables. Specific procedures are
 available when the model also included categorical (> 2 categories) or restricted cubic spline
 variables. These pooling methods are: “D1” is pooling of the total covariance matrix,
 ”D2” is pooling of Chi-square values and “MPR” is pooling of median p-values (MPR rule).
 Spline regression coefficients are defined by using the rcs function for restricted cubic
 splines of the rms package. A minimum number of 3 knots as defined under knots is required.

 A typical formula object has the form \code{Surv(time, status) ~ terms}. Categorical variables has to
 be defined as \code{Surv(time, status) ~ factor(variable)}, restricted cubic spline variables as
 \code{Surv(time, status) ~ rcs(variable, 3)}. Interaction terms can be defined as
 \code{Surv(time, status) ~ variable1*variable2} or \code{Surv(time, status) ~ variable1 + variable2 + 
 variable1:variable2}. All variables in the terms part have to be separated by a "+". If a formula
 object is used set predictors, cat.predictors, spline.predictors or int.predictors
 at the default value of NULL.
}
\section{Vignettes}{

  https://mwheymans.github.io/psfmi/articles/psfmi_CoxModels.html
}

\examples{
 pool_coxr <- psfmi_coxr(formula = Surv(Time, Status) ~ Pain + Tampascale +
                       Radiation + Radiation*Pain + Age + Duration + Previous,
                     data=lbpmicox, p.crit = 0.05, direction="BW", nimp=5, impvar="Impnr",
                     keep.predictors = "Radiation*Pain", method="D1")
                     
 pool_coxr$RR_model_final
 
}
\references{
Eekhout I, van de Wiel MA, Heymans MW. Methods for significance testing of categorical
  covariates in logistic regression models after multiple imputation: power and applicability
  analysis. BMC Med Res Methodol. 2017;17(1):129.

Enders CK (2010). Applied missing data analysis. New York: The Guilford Press.

van de Wiel MA, Berkhof J, van Wieringen WN. Testing the prediction error difference between
  2 predictors. Biostatistics. 2009;10:550-60.

Marshall A, Altman DG, Holder RL, Royston P. Combining estimates of interest in prognostic
  modelling studies after multiple imputation: current practice and guidelines. BMC Med Res Methodol.
  2009;9:57.

Van Buuren S. (2018). Flexible Imputation of Missing Data. 2nd Edition. Chapman & Hall/CRC
  Interdisciplinary Statistics. Boca Raton.

EW. Steyerberg (2019). Clinical Prediction MOdels. A Practical Approach
 to Development, Validation, and Updating (2nd edition). Springer Nature Switzerland AG.

http://missingdatasolutions.rbind.io/
}
\author{
Martijn Heymans, 2020
}
