% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readsdmx.R
\name{read_sdmx}
\alias{read_sdmx}
\title{Read SDMX data}
\usage{
read_sdmx(path, destfile = tempfile(fileext = ".xml"), quiet = TRUE,
  method = "libcurl", mode = "w", ...)
}
\arguments{
\item{path}{Character; the path to an SDMX-ML xml file}

\item{destfile}{A character string with the name where the downloaded
    file is saved.  Tilde-expansion is performed.}

\item{quiet}{If \code{TRUE}, suppress status messages (if any), and
    the progress bar.}

\item{method}{Method to be used for downloading files.  Current
    download methods are \code{"internal"}, \code{"wininet"} (Windows
    only) \code{"libcurl"}, \code{"wget"} and \code{"curl"}, and there
    is a value \code{"auto"}: see \sQuote{Details} and \sQuote{Note}.

    The method can also be set through the option
    \code{"download.file.method"}: see \code{\link{options}()}.
  }

\item{mode}{character.  The mode with which to write the file.  Useful
    values are \code{"w"}, \code{"wb"} (binary), \code{"a"} (append) and
    \code{"ab"}.  Not used for methods \code{"wget"} and \code{"curl"}.
}

\item{...}{allow additional arguments to be passed, unused.}
}
\value{
data.frame object
}
\description{
read SDMX data into R as dataframes
}
\details{
read_sdmx returns a dataframe with the SDMX data 'as-is' which means
  that all columns will be character vectors. The base R function `download.file` is used when
  a url is provided to read_sdmx.
}
\examples{
f <- system.file("extdata/compact_2.0.xml", package = "readsdmx")
d <- readsdmx::read_sdmx(f)

\donttest{
u <-
 "https://stats.oecd.org/restsdmx/sdmx.ashx/GetData/HH_DASH/..Q/all?format=compact_v2"
d <- readsdmx::read_sdmx(u)
}

}
