% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processFile.R
\name{mergeProcessedFits}
\alias{mergeProcessedFits}
\title{Merge Processed Fits}
\usage{
mergeProcessedFits(processedFitList)
}
\arguments{
\item{processedFitList}{list of processed fits as produced by
\code{\link{processFit}}.}
}
\value{
similar list as returned by \code{\link{processFit}} just with
  matrix entries instead of vectors.
}
\description{
Combine list of processed fits into one list in matrix form.
}
\examples{
  preparedDataset <-
      prepareMixedEffectDataset(Reaction ~ Days + (Days|Subject),
                                sleepstudy)
  set.seed(1)
  datasets <- generateMixedEffectDatasets(2, preparedDataset)

  fits <- fitDatasets_lmer(datasets)
  processedFits <- lapply(fits, processFit, all = TRUE)
  merged <- mergeProcessedFits(processedFits)
  str(merged)
}
