% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeronaFreemanSC.R
\name{PeronaFreemanSC}
\alias{PeronaFreemanSC}
\title{Bi-parted Spectral Clustering. Peronna and Freeman.}
\usage{
PeronaFreemanSC(W, flagDiagZero = FALSE, verbose = FALSE)
}
\arguments{
\item{W}{Gram Similarity Matrix.}

\item{flagDiagZero}{if True, Put zero on the similarity matrix W.}

\item{verbose}{To output the verbose in the terminal.}
}
\value{
returns a list containing the following elements:
\itemize{
 \item{cluster: }{a vector containing the cluster}
 \item{eigenVect: }{a vector containing the eigenvectors}
 \item{eigenVal: }{a vector containing the eigenvalues}
}
}
\description{
Bi-parted spectral clustering based on Peronna and Freeman algorithm, which separates the data into two distinct clusters
}
\examples{
### Example 1: 2 disks of the same size
n<-100 ; r1<-1
x<-(runif(n)-0.5)*2;
y<-(runif(n)-0.5)*2
keep1<-which((x*2+y*2)<(r1*2))
disk1<-data.frame(x+3*r1,y)[keep1,]
disk2 <-data.frame(x-3*r1,y)[keep1,]
sameTwoDisks <- rbind(disk1,disk2)
W <- compute.similarity.ZP(scale(sameTwoDisks))
res <- PeronaFreemanSC(W,flagDiagZero=TRUE,verbose=TRUE)
plot(sameTwoDisks, col = res$cluster)
plot(res$eigenVect[,1:2], col = res$cluster, main="spectral space",
     xlim=c(-1,1),ylim=c(-1,1)); points(0,0,pch='+');
plot(res$eigenVal, main="Laplacian eigenvalues",pch='+'); 

### Example 2: Speed and Stopping Distances of Cars
W <- compute.similarity.ZP(scale(iris[,-5]))
res <- PeronaFreemanSC(W,flagDiagZero=TRUE,verbose=TRUE)
plot(iris, col = res$cluster)
plot(res$eigenVect[,1:2], col = res$cluster, main="spectral space",
     xlim=c(-1,1),ylim=c(-1,1)); points(0,0,pch='+');
plot(res$eigenVal, main="Laplacian eigenvalues",pch='+'); 
}
\references{
Perona, P. and Freeman, W. (1998). A factorization approach to grouping. In European Conference on Computer Vision, pages 655-670
}
\author{
Emilie Poisson Caillault and Erwan Vincent
}
