% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeKclust2.R
\name{compute.kclust2}
\alias{compute.kclust2}
\title{K clust compute selection V2}
\usage{
compute.kclust2(
  eigenValues,
  method = "default",
  Kmax = 20,
  tolerence = 1,
  threshold = 0.9,
  verbose = FALSE
)
}
\arguments{
\item{eigenValues}{The eigenvalues of the laplacian matrix.}

\item{method}{The method that will be used. "default" to let the function choose the most suitable method. "PEV" for the Principal EigenValue method. "GAP" for the GAP method.}

\item{Kmax}{The maximum number of cluster which is allowed.}

\item{tolerence}{The tolerance allowed for the Principal EigenValue method.}

\item{threshold}{The threshold to select the dominant eigenvalue for the GAP method.}

\item{verbose}{To output the verbose in the terminal.}
}
\value{
a vector which contain the number of cluster to compute.
}
\description{
Function which select the number of cluster to compute thanks to a selected method
}
\author{
Emilie Poisson Caillault and Erwan Vincent
}
