% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slu_date_to_r.R
\name{slu_date_to_r}
\alias{slu_date_to_r}
\title{Converts dates stored on 'SQLite' to their original values}
\usage{
slu_date_to_r(date_sqlite)
}
\arguments{
\item{date_sqlite}{the numbers that result from inserting dates on 'SQLite'}
}
\value{
the dates that were originally inserted
}
\description{
Converts dates stored on 'SQLite' to their original values
}
\examples{
data <- data.frame(date = as.Date("2021-09-18"))
con <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
DBI::dbWriteTable(conn = con, name = "dates", value = data )
data_from_bd <- DBI::dbReadTable(conn = con, name = "dates")
original_date <- slu_date_to_r(data_from_bd$date)
DBI::dbDisconnect(con)

}
