% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_tools.R
\name{parse_regex_pattern}
\alias{parse_regex_pattern}
\title{\code{stringmagic}'s regular expression parser}
\usage{
parse_regex_pattern(
  pattern,
  authorized_flags,
  parse_flags = TRUE,
  parse_logical = TRUE,
  envir = parent.frame()
)
}
\arguments{
\item{pattern}{Character scalar, the regular expression pattern to parse.}

\item{authorized_flags}{Character vector representing the flags to be parsed.
Use the empty string if no flags are allowed.}

\item{parse_flags}{Logical scalar, default is \code{TRUE}. Whether to parse the
optional regex flags.}

\item{parse_logical}{Logical scalar, default is \code{TRUE}. Whether to parse logical
regex operations, similarly to \code{\link[=string_get]{string_get()}}.}

\item{envir}{An environment, default is \code{parent.frame()}. Only used if the flag
\code{magic} is present, it is used to find the variables to be interpolated.}
}
\value{
This function always returns a list of 4 elements:
\itemize{
\item \code{flags}: the character vector of flags. If no flags were found, this is the empty string.
\item \code{patterns}: the vector of regex patterns.
\item \code{is_or}: logical vector of the same length as \code{patterns}. Indicates for each
pattern if it should be attached to the previous patterns with a logical OR (\code{FALSE}
means a logical \code{AND}).
\item \code{is_not}: logical vector of the same length as \code{patterns}. Indicates for each pattern
if it should be negated.
}
}
\description{
Parse regular expression with custom flags and obtain the final pattern
to be parsed as well as the vector of flags
}
\details{
This is an internal tool that is exposed in order to facilitate checking what's going on.

There is no error handling.
}
\examples{

parse_regex_pattern("f/hello", c("fixed", "ignore"))

x = "john"
parse_regex_pattern("fm/{x} | Doe", c("fixed", "ignore", "magic"))

}
\seealso{
String operations: \code{\link[=string_is]{string_is()}}, \code{\link[=string_get]{string_get()}}, \code{\link[=string_clean]{string_clean()}}, \code{\link[=string_split2df]{string_split2df()}}.
Chain basic operations with \code{\link[=string_ops]{string_ops()}}. Clean character vectors efficiently
with \code{\link[=string_clean]{string_clean()}}.

Use \code{\link[=string_vec]{string_vec()}} to create simple string vectors.

String interpolation combined with operation chaining: \code{\link[=string_magic]{string_magic()}}. You can change \code{string_magic}
default values with \code{\link[=string_magic_alias]{string_magic_alias()}} and add custom operations with \code{\link[=string_magic_register_fun]{string_magic_register_fun()}}.

Display messages while benefiting from \code{string_magic} interpolation with \code{\link[=cat_magic]{cat_magic()}} and \code{\link[=message_magic]{message_magic()}}.

Other tools with aliases: 
\code{\link{cat_magic_alias}()},
\code{\link{string_magic_alias}()},
\code{\link{string_magic}()},
\code{\link{string_ops_alias}()},
\code{\link{string_vec_alias}()}
}
\author{
Laurent Berge
}
