% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock2.R
\name{local_mocked_bindings}
\alias{local_mocked_bindings}
\alias{with_mocked_bindings}
\title{Mocking tools}
\usage{
local_mocked_bindings(..., .package = NULL, .env = caller_env())

with_mocked_bindings(code, ..., .package = NULL)
}
\arguments{
\item{...}{Name-value pairs providing functions to mock.}

\item{.package}{The name of the package where mocked functions should be
inserted. Generally, you should not need to supply this as it will be
automatically detected when whole package tests are run or when there's
one package under active development (i.e. loaded with
\code{\link[pkgload:load_all]{pkgload::load_all()}}).}

\item{.env}{Environment that defines effect scope. For expert use only.}

\item{code}{Code to execute with specified bindings.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

These functions represent a second attempt at bringing mocking to testthat,
incorporating what we've learned from the mockr, mockery, and mockthat package.

\code{with_mocked_bindings()} and \code{local_mocked_bindings()} work by temporarily
changing variable bindings in the namespace of namespace \code{.package}.
Generally, it's only safe to mock packages that you own. If you mock other
packages, we recommend using \code{skip_on_cran()} to avoid CRAN failures if the
implementation changes.

These functions do not currently affect registered S3 methods.
}
