% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-files.R
\name{test_dir}
\alias{test_dir}
\title{Run all tests in a directory}
\usage{
test_dir(
  path,
  filter = NULL,
  reporter = NULL,
  env = NULL,
  ...,
  load_helpers = TRUE,
  stop_on_failure = TRUE,
  stop_on_warning = FALSE,
  wrap = lifecycle::deprecated(),
  package = NULL,
  load_package = c("none", "installed", "source")
)
}
\arguments{
\item{path}{Path to directory containing tests.}

\item{filter}{If not \code{NULL}, only tests with file names matching this
regular expression will be executed. Matching is performed on the file
name after it's stripped of \code{"test-"} and \code{".R"}.}

\item{reporter}{Reporter to use to summarise output. Can be supplied
as a string (e.g. "summary") or as an R6 object
(e.g. \code{SummaryReporter$new()}).

See \link{Reporter} for more details and a list of built-in reporters.}

\item{env}{Environment in which to execute the tests. Expert use only.}

\item{...}{Additional arguments passed to \code{\link[=grepl]{grepl()}} to control filtering.}

\item{load_helpers}{Source helper files before running the tests?}

\item{stop_on_failure}{If \code{TRUE}, throw an error if any tests fail.}

\item{stop_on_warning}{If \code{TRUE}, throw an error if any tests generate
warnings.}

\item{wrap}{DEPRECATED}

\item{package}{If these tests belong to a package, the name of the package.}

\item{load_package}{Strategy to use for load package code:
\itemize{
\item "none", the default, doesn't load the package.
\item "installed", uses \code{\link[=library]{library()}} to load an installed package.
\item "source", uses \code{\link[pkgload:load_all]{pkgload::load_all()}} to a source package.
To configure the arguments passed to \code{load_all()}, add this
field in your DESCRIPTION file:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Config/testthat/load-all: list(export_all = FALSE, helpers = FALSE)
}\if{html}{\out{</div>}}
}}
}
\value{
A list (invisibly) containing data about the test results.
}
\description{
This function is the low-level workhorse that powers \code{\link[=test_local]{test_local()}} and
\code{\link[=test_package]{test_package()}}. Generally, you should not call this function directly.
In particular, you are responsible for ensuring that the functions to test
are available in the test \code{env} (e.g. via \code{load_package}).

See \code{vignette("special-files")} to learn more about the conventions for test,
helper, and setup files that testthat uses, and what you might use each for.
}
\section{Environments}{

Each test is run in a clean environment to keep tests as isolated as
possible. For package tests, that environment inherits from the package's
namespace environment, so that tests can access internal functions
and objects.
}

\keyword{internal}
