% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-files.R
\name{test_file}
\alias{test_file}
\title{Run tests in a single file}
\usage{
test_file(
  path,
  reporter = default_compact_reporter(),
  desc = NULL,
  package = NULL,
  ...
)
}
\arguments{
\item{path}{Path to file.}

\item{reporter}{Reporter to use to summarise output. Can be supplied
as a string (e.g. "summary") or as an R6 object
(e.g. \code{SummaryReporter$new()}).

See \link{Reporter} for more details and a list of built-in reporters.}

\item{desc}{Optionally, supply a string here to run only a single
test (\code{test_that()} or \code{describe()}) with this \code{desc}ription.}

\item{package}{If these tests belong to a package, the name of the package.}

\item{...}{Additional parameters passed on to \code{test_dir()}}
}
\value{
A list (invisibly) containing data about the test results.
}
\description{
Helper, setup, and teardown files located in the same directory as the
test will also be run. See \code{vignette("special-files")} for details.
}
\section{Environments}{

Each test is run in a clean environment to keep tests as isolated as
possible. For package tests, that environment inherits from the package's
namespace environment, so that tests can access internal functions
and objects.
}

\examples{
path <- testthat_example("success")
test_file(path)
test_file(path, desc = "some tests have warnings")
test_file(path, reporter = "minimal")
}
