#' @section Constructor:
#'   \code{make_tmle3_task(data, npsem, ...)}
#'                      
#'   \describe{
#'     \item{\code{data}}{A \code{data.frame} or \code{data.table} containing the underlying data
#'     }
#'     \item{\code{npsem}}{A list of \code{\link{tmle3_Node}} objects, where each is created using \code{\link{define_node}}. These specify the NPSEM. See examples.
#'     }
#'     \item{\code{...}}{Other arguments passed to the constructor of \code{\link[sl3]{sl3_Task}}. \strong{NB:} Support for these is currently limited.
#'     }
#'     }
#'     
#' @section Methods:
#'
#' \describe{
#' \item{\code{get_tmle_node(node_name, bound = FALSE)}}{
#'   Gets the data associated with a tmle_node. Bounds the data if requested.
#'
#'   \itemize{
#'     \item{\code{node_name}: character, the name of the node to get.
#'     }
#'     \item{\code{bound}: logical, if true the data is transformed to be in (0,1) based on pre-specified bounds.
#'     }
#'   }
#'   }
#'   
#'\item{\code{get_regression_task(target_node, bound = FALSE)}}{
#'   Gets a \code{\link[sl3]{sl3_Task}} suitable for fitting the conditional likelihood factor with the \code{target_node}
#'   as the outcome.
#'
#'   \itemize{
#'     \item{\code{target_node}: character, the name of the node to get.
#'     }
#'   }
#'   }
#'\item{\code{generate_counterfacutal_task(uuid, new_data)}}{
#'   Generates a new \code{tmle_Task} where some nodes are overridden to have counterfactual values.
#'
#'   \itemize{
#'     \item{\code{uuid}: A unique identifier for the counterfactual task, as generated by \code{\link[uuid]{UUIDgenerate}}
#'     \item{\code{new_data}: A \code{data.frame} or \code{data.table} with the counterfactual values. Column names must refer to node names in the \code{npsem} for this task.
#'     }
#'   }
#'   }
#'}
#'}
#'
#' @section Fields:
#' \describe{
#'   \item{\code{npsem}}{The list of \code{\link{tmle3_Node}} objects specifying the NPSEM}
#' }
