% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CF_likelihood.R
\name{CF_Likelihood}
\alias{CF_Likelihood}
\alias{make_CF_Likelihood}
\title{Counterfactual Likelihood}
\format{
\code{\link{R6Class}} object.
}
\usage{
make_CF_Likelihood(...)
}
\arguments{
\item{...}{Passes all arguments to the constructor. See documentation for the
Constructor below.}
}
\value{
\code{Likelihood} object
}
\description{
Represents a counterfactual likelihood where one or more likelihood factors has been replaced with an intervention as specified by \code{intervention_list}.
Inherits from \code{\link{Likelihood}}. Other factors (including their updates) are taken from an underlying \code{observed_likelihood} estimated from observed data.
}
\section{Constructor}{

\code{make_CF_Likelihood(observed_likelihood, intervention_list, ...)}

\describe{
\item{\code{observed_likelihood}}{\code{\link{Likelihood}} obect specifying the relevant factors of the observed likelihood
}
\item{\code{intervention_list}}{A list of objects inheriting from \code{\link{LF_base}}, representing the intervention.
}
\item{\code{...}}{Not currently used.
}
}
}

\section{Fields}{

\describe{
\item{\code{observed_likelihood}}{\code{\link{Likelihood}} obect specifying the relevant factors of the observed likelihood
}
\item{\code{intervention_list}}{A list of objects inheriting from \code{\link{LF_base}}, representing the intervention.
}
}
}

\seealso{
Other Likelihood objects: 
\code{\link{LF_base}},
\code{\link{LF_derived}},
\code{\link{LF_emp}},
\code{\link{LF_fit}},
\code{\link{LF_known}},
\code{\link{LF_static}},
\code{\link{LF_targeted}},
\code{\link{Likelihood}},
\code{\link{Targeted_Likelihood}},
\code{\link{define_lf}()}
}
\concept{Likelihood objects}
\keyword{data}
