% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LF_static.R
\name{LF_static}
\alias{LF_static}
\title{Static Likelihood Factor}
\format{
\code{\link{R6Class}} object.
}
\value{
\code{LF_base} object
}
\description{
Likelihood factor for a variable that only has one value with probability 1. This is used for static interventions.
Inherits from \code{\link{LF_base}}; see that page for documentation on likelihood factors in general.
}
\section{Constructor}{

\code{define_lf(LF_static, name, type, value, ...)}

\describe{
\item{\code{name}}{character, the name of the factor. Should match a node name in the nodes specified by \code{\link{tmle3_Task}$npsem}
}
\item{\code{type}}{character, either "density", for conditional density or, "mean" for conditional mean
}
\item{\code{value}}{the static value
}
\item{\code{...}}{Not currently used.
}
}
}

\section{Fields}{

\describe{
\item{\code{value}}{the static value.}
}
}

\seealso{
Other Likelihood objects: 
\code{\link{CF_Likelihood}},
\code{\link{LF_base}},
\code{\link{LF_derived}},
\code{\link{LF_emp}},
\code{\link{LF_fit}},
\code{\link{LF_known}},
\code{\link{LF_targeted}},
\code{\link{Likelihood}},
\code{\link{Targeted_Likelihood}},
\code{\link{define_lf}()}
}
\concept{Likelihood objects}
\keyword{data}
