% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Likelihood.R
\docType{class}
\name{Likelihood}
\alias{Likelihood}
\alias{make_Likelihood}
\title{Class for Likelihood}
\format{
\code{\link{R6Class}} object.
}
\usage{
make_Likelihood(...)
}
\arguments{
\item{...}{Passes all arguments to the constructor. See documentation for the
Constructor below.}
}
\value{
\code{Likelihood} object
}
\description{
This object represents an estimate of the relevant factors of the likelihood estimated from data, or based on \emph{a priori} knowledge where appropriate.
That is, it represents some subset of $P_n$. This object inherits from \code{\link[sl3]{Lrnr_base}}, and so shares some properties with \code{sl3} learners.
Specifically, to fit a likelihood object to data, one calls \code{likelihood$train(tmle3_task)}.
Each likelihood factor is represented by an object inheriting from \code{\link{LF_base}}.
}
\section{Constructor}{

\code{make_Likelihood(factor_list, ...)}

\describe{
\item{\code{factor_list}}{A list of objects inheriting from \code{\link{LF_base}}, representing the individual relevant factors.
}
\item{\code{...}}{Not currently used.
}
}
}

\section{Methods}{


\describe{
\item{\code{validate_task(tmle_task)}}{
Ensure that this likelihood is compatible with a particular \code{\link{tmle3_Task}}, in that the factor names must match the \code{tmle_task$npsem} names.

\itemize{
\item{\code{tmle_task}: the \code{\link{tmle3_Task}} to validate.
}
}
}

\item{\code{get_initial_likelihoods(tmle_task, nodes=NULL)}}{
Gets initial (i.e. before any TMLE updates) likelihood values for the specified \code{nodes} (or all nodes if none are specified)
for the observations in \code{tmle_task}.

\itemize{
\item{\code{tmle_task}: \code{\link{tmle3_Task}} to get likelihood values for
}
\item{\code{nodes}: character vectors, the list of nodes to get likelihood values for. If missing, values will be provided for all nodes.
}
}
}
\item{\code{get_likelihoods(tmle_task, nodes=NULL)}}{
Gets updated (i.e. after all TMLE updates) likelihood values for the specified \code{nodes} (or all nodes if none are specified)
for the observations in \code{tmle_task}.

\itemize{
\item{\code{tmle_task}: \code{\link{tmle3_Task}} to get likelihood values for
}
\item{\code{nodes}: character vectors, the list of nodes to get likelihood values for. If missing, values will be provided for all nodes.
}
}
}
\item{\code{get_possible_counterfactuals(nodes)}}{
Gets all possible combination of counterfactual values for a set of nodes. This is useful for marginalizing over a node. Returns a \code{data.frame}
with one row per possibility.

\itemize{
\item{\code{nodes}: character vectors, the list of nodes to get counterfactual values for. If missing, values will be provided for all nodes.
}
}
}
}
}

\section{Fields}{

\describe{
\item{\code{factor_list}}{The list of \code{\link{LF_base}} objects specifying the relevant likelihood factors}
\item{\code{observed_values}}{The likelihood values for the observed data. These are cached, as they are used in many places in TMLE}
\item{\code{update_list}}{A list of tmle_updates that have been calculated for this likelihood}
}
}

\seealso{
Other Likelihood objects: 
\code{\link{CF_Likelihood}},
\code{\link{LF_base}},
\code{\link{LF_derived}},
\code{\link{LF_emp}},
\code{\link{LF_fit}},
\code{\link{LF_known}},
\code{\link{LF_static}},
\code{\link{LF_targeted}},
\code{\link{Targeted_Likelihood}},
\code{\link{define_lf}()}
}
\concept{Likelihood objects}
\keyword{data}
