% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Param_MSM.R
\name{Param_MSM}
\alias{Param_MSM}
\title{Stratified Parameter Estimates via MSM}
\format{
\code{\link{R6Class}} object.
}
\value{
\code{Param_base} object
}
\description{
Stratified Parameter Estimates via MSM
}
\section{Current Issues}{

\itemize{
\item clever covariates doesn't support updates; always uses initial (necessary for iterative TMLE, e.g. stochastic intervention)
\item clever covariate gets recalculated all the time (inefficient)
}
}

\section{Constructor}{

\code{define_param(Param_MSM, observed_likelihood, strata_variable, ...)}

\describe{
\item{\code{observed_likelihood}}{A \code{\link{Likelihood}} corresponding to the observed likelihood
}
\item{\code{msm}}{form of the MSM. Default is "A + V", consistent with the default of
\code{treatment_node} and \code{strata_name}.
}
\item{\code{weight}}{"Cond.Prob.", "Unif." or custom input function.
Note that custom function should support vector input. Default is "Cond.Prob.".
}
\item{\code{...}}{Not currently used.
}
\item{\code{covariate_node}}{character, the name of the node that should be treated as the covariate
}
\item{\code{treatment_node}}{character, the name of the node that should be treated as the treatment
}
\item{\code{outcome_node}}{character, the name of the node that should be treated as the outcome
}
}
}

\section{Fields}{

\describe{
\item{\code{cf_likelihood}}{the counterfactual likelihood for this treatment
}
}
}

\seealso{
Other Parameters: 
\code{\link{Param_ATC}},
\code{\link{Param_ATE}},
\code{\link{Param_ATT}},
\code{\link{Param_TSM}},
\code{\link{Param_base}},
\code{\link{Param_delta}},
\code{\link{Param_mean}},
\code{\link{Param_stratified}},
\code{\link{Param_survival}},
\code{\link{define_param}()},
\code{\link{tmle3_Fit}}
}
\concept{Parameters}
\keyword{data}
