% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-beast.R
\name{write.beast.newick}
\alias{write.beast.newick}
\title{write.beast.newick}
\usage{
write.beast.newick(
  treedata,
  file = "",
  append = FALSE,
  digits = 10,
  tree.prefix = ""
)
}
\arguments{
\item{treedata}{\code{treedata} object}

\item{file}{output file. If file = "", print the output content on screen}

\item{append}{logical. Only used if the argument 'file' is the name of file
(and not a connection or "|cmd").  If 'TRUE' output will be appended to
'file'; otherwise, it will overwrite the contents of file.}

\item{digits}{integer, the indicating the number of decimal places, default is 10.}

\item{tree.prefix, }{character the tree prefix, default is "".}
}
\value{
output file or file content on screen
}
\description{
Export \code{treedata} object to BEAST Newick file. This is useful for making BEAST starting trees with metadata
}
\examples{
nhxfile <- system.file("extdata/NHX", "phyldog.nhx", package="treeio")
nhx <- read.nhx(nhxfile)
write.beast.newick(nhx)
}
\author{
Guangchuang Yu
}
