% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimARMA.R
\name{sim.ARMA}
\alias{sim.ARMA}
\title{Simulation of ARMA(p,q) model.}
\usage{
sim.ARMA(
  n,
  ar = NULL,
  ma = NULL,
  sigma = 1,
  eta = NULL,
  method = "strong",
  k = 1,
  mu = 0,
  ...
)
}
\arguments{
\item{n}{Number of observations.}

\item{ar}{Vector of AR coefficients. If \code{NULL},  the simulation is a MA process.}

\item{ma}{Vector of MA coefficients. If \code{NULL},  the simulation is a AR process.}

\item{sigma}{Standard deviation.}

\item{eta}{Vector of white noise sequence. Allows the user to use his own
white noise.}

\item{method}{Defines the kind of noise used for the simulation. By default,
the noise used is strong. See 'Details'.}

\item{k}{Integer used in the creation of the noise. See 'Details'.}

\item{mu}{Integer for the mean of the series.}

\item{...}{Arguments needed to simulate GARCH noise. See 'Details'.}
}
\value{
Returns a vector containing the \code{n} simulated observations of the
 time series.
}
\description{
Simulates an ARMA, AR or MA process according to the arguments
 given.
}
\details{
ARMA model is of the following form : \deqn{ X_{t}-\mu = e_{t} + a_{1} (X_{t-1}-\mu)
+ a_{2} (X_{t-2}-\mu) + ... + a_{p} (X_{t-p}-\mu) - b_1 e_{t-1} - b_2 e_{t-2} - ... - b_{q}  e_{t-q}}
 where \eqn{e_t} is a sequence  of uncorrelated random variables with zero
 mean and common variance \eqn{\sigma^{2} > 0} . \eqn{ar = (a_{1}, a_{2}, ..., a_{p})} are
 autoregressive coefficients and \eqn{ma = (b_{1}, b_{2}, ... , b_{q})} are moving
 average coefficients. Characteristic polynomials of ar and ma must
 constitute a stationary process.

 Method "\code{strong}" realise a simulation with gaussian white noise.

 Method "\code{product}", "\code{ratio}" and "\code{product.square}"
 realise a simulation with a weak white noise. These methods employ
 respectively the functions  \code{\link{wnPT}}, \code{\link{wnRT}} and
 \code{\link{wnPT_SQ}} to simulate nonlinear ARMA model. So, the
 paramater \code{k} is an argument of these functions. See \code{\link{wnPT}}, \code{\link{wnRT}}
 or \code{\link{wnPT_SQ}}.

 Method "\code{GARCH}" gives an ARMA process with a GARCH noise. See
 \code{\link{simGARCH}}.
}
\examples{
y <- sim.ARMA(n = 100, ar = 0.95, ma = -0.6, method = "strong" )
y2 <- sim.ARMA(n = 100, ar = 0.95, ma = -0.6, method = "ratio")
y3 <- sim.ARMA(n = 100,  ar = 0.95, ma = -0.6, method = "GARCH", c = 1, A = 0.1, B = 0.88)
y4 <- sim.ARMA(n = 100, ar = 0.95, ma = -0.6, method = "product")
y5 <- sim.ARMA(n = 100, ar = 0.95, ma = -0.6, method = "product.square")

}
\references{
Francq, C. and Zakoïan, J.M. 1998, Estimating linear representations
 of nonlinear processes, \emph{Journal of Statistical Planning and
 Inference}, vol. 68, no. 1, pp. 145-165
}
\seealso{
\code{\link[stats]{arima.sim}}
}
