#!/bin/sh
# aescrypt.sh
# This shell validates the 'aescrypt' and 'aesget' encrypytion and decryption algorithms on various Unix/Linux platforms.
# This script is to be run first on an i686 Linux box, and the results stored on cvs.
# Then, when testing a Linux or Unix port on another platform, the same input files are copied to the platform to be tested.
# Then, this script is to be run again, and the files compared.
# If the files are the same, then the port was successful.
### 1) Find out what platform we're running on.
### 2) Encrypt the test file on this platform, using 'aescrypt', and the keyfile stored on cvs.
### 3) Decrypt the encrypted test file, using 'aesget' and the keyfile stored on cvs.
### 4) Compare the unencrypted file from the i686 Linux box, and the decrypted file on the platform being tested.
###    If they are the same, all is well.

### 1) Find out what platform we're running on.
echo "Deciding what platform we are on..."
TRYOS=`uname`
#if test $TRYOS == "UnixWare"
if [ $TRYOS = "UnixWare" ]
then
	OS=`uname`
	ARCH=`uname -m`
else
	OS=`uname | tr "/" "-"`
	ARCH=`uname -m | tr "/" "-"`
fi

echo "We are running ${OS} on a ${ARCH} machine."

### 2) Encrypt the test file on this platform, using 'aescrypt', and the keyfile stored on cvs.
if [ -f "aescrypt.${OS}.${ARCH}.encrypted.src" ]	# If the file already exists, remove it
then
	echo "Removing 'aescrypt.${OS}.${ARCH}.encrypted.src'..."
	rm -f aescrypt.${OS}.${ARCH}.encrypted.src
fi

# Use the previously-generated 'aescrypt.Linux.i686.key' file to encrypt the test file.
#  First, check to make sure the "aescrypt" executable is in the current directory.
if [ ! -f "aescrypt" ]
then
	if [ -f "/opt/brupro/bin/aescrypt" ]
	then
		cp -p /opt/brupro/bin/aescrypt .
	else
		echo "Could not find the 'aescrypt' executable. Aborting..."
		exit 1
	fi
fi

./aescrypt -k aescrypt.Linux.i686.key < aescrypt.Linux.i686.src > aescrypt.${OS}.${ARCH}.encrypted.src

### 3) Decrypt the encrypted test file, using 'aesget' and the keyfile stored on cvs.
if [ -f "aescrypt.${OS}.${ARCH}.decrypted.src" ]	# If the file already exists, remove it
then
	echo "Removing 'aescrypt.${OS}.${ARCH}.decrypted.src'..."
	rm -f aescrypt.${OS}.${ARCH}.decrypted.src
fi

# Use the previously-generated 'aescrypt.Linux.i686.key' file to decrypt the encrypted test file.
#  First, check to make sure the "aesget" executable is in the current directory.
if [ ! -f "aesget" ]
then
	if [ -f "/opt/brupro/bin/aesget" ]
	then
		cp -p /opt/brupro/bin/aesget .
	else
		echo "Could not find the 'aesget' executable. Aborting..."
		exit 1
	fi
fi

./aesget -k aescrypt.Linux.i686.key < aescrypt.${OS}.${ARCH}.encrypted.src > aescrypt.${OS}.${ARCH}.decrypted.src

### 4) Compare the unencrypted file from the i686 Linux box, and the decrypted file on the platform being tested.
###    If they are the same, all is well.
diff aescrypt.Linux.i686.src aescrypt.${OS}.${ARCH}.decrypted.src
#if test $? = 0
if test $? -eq 0
then
	echo "The test file 'aescrypt.Linux.i686.src' decrypted correctly on this $OS/$ARCH platform."
else
	echo "ERROR!!! The file 'aescrypt.Linux.i686.src' did NOT decrypt correctly on this $OS/$ARCH platform."
fi
