// Copyright 2016 The SwiftShader Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef sw_Stream_hpp
#define sw_Stream_hpp

#include "Vulkan/VulkanPlatform.hpp"

namespace sw {

struct Stream
{
	const void *buffer = nullptr;
	unsigned int robustnessSize = 0;
	VkVertexInputRate inputRate = VK_VERTEX_INPUT_RATE_VERTEX;
	unsigned int vertexStride = 0;
	unsigned int instanceStride = 0;
	VkFormat format = VK_FORMAT_UNDEFINED;
	unsigned int offset = 0;
	unsigned int binding = 0;
};

}  // namespace sw

#endif  // sw_Stream_hpp
