;; Scheduling description for IBM PowerPC 403 and PowerPC 405  processors.
;;   Copyright (C) 2003, 2004 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to the
;; Free Software Foundation, 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

(define_automaton "ppc40x,ppc40xiu")
(define_cpu_unit "bpu_40x,fpu_405" "ppc40x")
(define_cpu_unit "iu_40x" "ppc40xiu")

;; PPC401 / PPC403 / PPC405 32-bit integer only  IU BPU
;; Embedded PowerPC controller
;; In-order execution
;; Max issue two insns/cycle (includes one branch)
(define_insn_reservation "ppc403-load" 2
  (and (eq_attr "type" "load,load_ext,load_ext_u,load_ext_ux,load_ux,load_u")
       (eq_attr "cpu" "ppc403,ppc405"))
  "iu_40x")

(define_insn_reservation "ppc403-store" 1
  (and (eq_attr "type" "store,store_ux,store_u")
       (eq_attr "cpu" "ppc403,ppc405"))
  "iu_40x")

(define_insn_reservation "ppc403-integer" 1
  (and (eq_attr "type" "integer,insert_word")
       (eq_attr "cpu" "ppc403,ppc405"))
  "iu_40x")

(define_insn_reservation "ppc403-two" 1
  (and (eq_attr "type" "two")
       (eq_attr "cpu" "ppc403,ppc405"))
  "iu_40x,iu_40x")

(define_insn_reservation "ppc403-three" 1
  (and (eq_attr "type" "three")
       (eq_attr "cpu" "ppc403,ppc405"))
  "iu_40x,iu_40x,iu_40x")

(define_insn_reservation "ppc403-compare" 3
  (and (eq_attr "type" "cmp,fast_compare,compare,delayed_compare")
       (eq_attr "cpu" "ppc403,ppc405"))
  "iu_40x,nothing,bpu_40x")

(define_insn_reservation "ppc403-imul" 4
  (and (eq_attr "type" "imul,imul2,imul3,imul_compare")
       (eq_attr "cpu" "ppc403"))
  "iu_40x*4")

(define_insn_reservation "ppc405-imul" 5
  (and (eq_attr "type" "imul,imul_compare")
       (eq_attr "cpu" "ppc405"))
  "iu_40x*4")

(define_insn_reservation "ppc405-imul2" 3
  (and (eq_attr "type" "imul2")
       (eq_attr "cpu" "ppc405"))
  "iu_40x*2")

(define_insn_reservation "ppc405-imul3" 2
  (and (eq_attr "type" "imul3")
       (eq_attr "cpu" "ppc405"))
  "iu_40x")

(define_insn_reservation "ppc403-idiv" 33
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppc403,ppc405"))
  "iu_40x*33")

(define_insn_reservation "ppc403-mfcr" 2
  (and (eq_attr "type" "mfcr")
       (eq_attr "cpu" "ppc403,ppc405"))
  "iu_40x")

(define_insn_reservation "ppc403-mtcr" 3
  (and (eq_attr "type" "mtcr")
       (eq_attr "cpu" "ppc403,ppc405"))
  "iu_40x")

(define_insn_reservation "ppc403-mtjmpr" 4
  (and (eq_attr "type" "mtjmpr")
       (eq_attr "cpu" "ppc403,ppc405"))
  "iu_40x")

(define_insn_reservation "ppc403-mfjmpr" 2
  (and (eq_attr "type" "mfjmpr")
       (eq_attr "cpu" "ppc403,ppc405"))
  "iu_40x")

(define_insn_reservation "ppc403-jmpreg" 1
  (and (eq_attr "type" "jmpreg,branch")
       (eq_attr "cpu" "ppc403,ppc405"))
  "bpu_40x")

(define_insn_reservation "ppc403-cr" 2
  (and (eq_attr "type" "cr_logical,delayed_cr")
       (eq_attr "cpu" "ppc403,ppc405"))
  "bpu_40x")

(define_insn_reservation "ppc405-float" 11
  (and (eq_attr "type" "fpload,fpload_ux,fpload_u,fpstore,fpstore_ux,fpstore_u,fpcompare,fp,dmul,sdiv,ddiv")
       (eq_attr "cpu" "ppc405"))
  "fpu_405*10")
