%
% This file is part of AtomVM.
%
% Copyright 2022 Paul Guyot <pguyot@kallisys.net>
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%    http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
%
% SPDX-License-Identifier: Apache-2.0 OR LGPL-2.1-or-later
%

-module(test_system_flag).

-export([start/0]).

start() ->
    ok = test_schedulers_online(),
    0.

test_schedulers_online() ->
    case erlang:system_info(schedulers) of
        % probably not an SMP build
        1 ->
            ok;
        Schedulers when is_integer(Schedulers) ->
            Online = erlang:system_info(schedulers_online),
            Online = erlang:system_flag(schedulers_online, 1),
            true = Online =< Schedulers,
            1 = erlang:system_info(schedulers_online),
            1 = erlang:system_flag(schedulers_online, 2),
            2 = erlang:system_info(schedulers_online),
            Overflow =
                if
                    Online < Schedulers -> Schedulers;
                    true -> Online
                end + 1,
            ok =
                try
                    erlang:system_flag(schedulers_online, Overflow),
                    expected_error
                catch
                    error:badarg -> ok
                end,
            2 = erlang:system_flag(schedulers_online, Online),
            Online = erlang:system_info(schedulers_online),
            ok =
                try
                    erlang:system_flag(schedulers_online, 0),
                    expected_error
                catch
                    error:badarg -> ok
                end,
            Online = erlang:system_info(schedulers_online),
            ok
    end.
