/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.IdentityHashMap;
import java.util.Map;
import org.basex.data.Data;
import org.basex.io.IO;

public final class Datas {
    private final IdentityHashMap<Data, Integer> list = new IdentityHashMap();

    public synchronized Data pin(String name) {
        Map.Entry<Data, Integer> entry = this.get(name);
        if (entry == null) {
            return null;
        }
        Data data = entry.getKey();
        this.list.put(data, entry.getValue() + 1);
        return data;
    }

    public synchronized void pin(Data data) {
        this.list.compute(data, (key, pins) -> pins == null ? 1 : pins + 1);
    }

    public synchronized void unpin(Data data) {
        Integer pins = this.list.get(data);
        if (pins == null) {
            return;
        }
        int p = pins;
        if (p == 1) {
            data.close();
            this.list.remove(data);
        } else {
            this.list.put(data, p - 1);
        }
    }

    synchronized boolean pinned(String name) {
        return this.get(name) != null;
    }

    public synchronized int pins(String name) {
        Map.Entry<Data, Integer> entry = this.get(name);
        return entry == null ? 0 : entry.getValue();
    }

    synchronized void close() {
        for (Data data : this.list.keySet()) {
            data.close();
        }
        this.list.clear();
    }

    private Map.Entry<Data, Integer> get(String name) {
        for (Map.Entry<Data, Integer> entry : this.list.entrySet()) {
            if (!IO.equals(entry.getKey().meta.name, name)) continue;
            return entry;
        }
        return null;
    }
}

