/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Insets;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXWindow;

public final class BaseXButton
extends JButton {
    private static final AbstractButton TEMPLATE = BaseXButton.style(new JToggleButton());

    public BaseXButton(BaseXWindow win, String label) {
        super(label);
        BaseXLayout.addInteraction(this, win);
        BaseXDialog dialog = win.dialog();
        if (dialog == null) {
            return;
        }
        this.addActionListener(e -> {
            String text = this.getText();
            if (text.equals(Text.B_CANCEL)) {
                dialog.cancel();
            } else if (text.equals(Text.B_OK)) {
                dialog.close();
            } else {
                dialog.action(e.getSource());
            }
        });
        this.addKeyListener(e -> {
            if (BaseXKeys.ESCAPE.is(e)) {
                dialog.cancel();
            } else if (BaseXKeys.NEXTCHAR.is(e) || BaseXKeys.NEXTLINE.is(e)) {
                this.transferFocus();
            } else if (BaseXKeys.PREVCHAR.is(e) || BaseXKeys.PREVLINE.is(e)) {
                this.transferFocusBackward();
            }
        });
        BaseXLayout.setMnemonic(this, dialog.mnem);
    }

    public static AbstractButton get(String icon, String tooltip, boolean toggle, GUI gui) {
        AbstractButton button = toggle ? new JToggleButton() : new JButton();
        BaseXButton.init(button, icon, tooltip, gui);
        if (!toggle) {
            button.setBorder(TEMPLATE.getBorder());
            button.setMargin(TEMPLATE.getMargin());
        }
        button.setFocusable(false);
        return button;
    }

    private static void init(AbstractButton button, String icon, String tooltip, GUI gui) {
        button.setIcon(BaseXImages.icon(icon));
        BaseXLayout.addInteraction(button, gui);
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
        BaseXButton.style(button);
    }

    private static AbstractButton style(AbstractButton button) {
        button.setOpaque(false);
        Insets in = button.getMargin();
        in.left /= 4;
        in.right /= 4;
        if (in.top < in.left) {
            button.setMargin(in);
        }
        return button;
    }

    public static AbstractButton command(GUICommand cmd, GUI gui) {
        String name = cmd.toString().toLowerCase(Locale.ENGLISH);
        AbstractButton button = BaseXButton.get(name, cmd.shortCut(), cmd.toggle(), gui);
        button.addActionListener(e -> cmd.execute(gui));
        return button;
    }

    @Override
    public void setEnabled(boolean flag) {
        if (flag != this.isEnabled()) {
            super.setEnabled(flag);
        }
    }
}

