/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.ArrayList;
import org.basex.core.Text;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryText;
import org.basex.query.expr.ExprInfo;
import org.basex.query.util.list.ValueList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public class QueryException
extends Exception {
    static final QueryException ERROR = new QueryException(""){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };
    private static final String[] NAMES = new String[]{"code", "description", "value", "module", "line-number", "column-number", "additional", "stack-trace", "map"};
    private static final SeqType[] TYPES = new SeqType[]{SeqType.QNAME_O, SeqType.STRING_ZO, SeqType.ITEM_ZM, SeqType.STRING_ZO, SeqType.INTEGER_ZO, SeqType.INTEGER_ZO, SeqType.ITEM_ZM, SeqType.STRING_O, SeqType.MAP_O};
    private static final QNm[] QNAMES = new QNm[NAMES.length];
    private static final Str[] STRINGS = new Str[NAMES.length];
    private final ArrayList<InputInfo> stack = new ArrayList();
    private final QNm name;
    private Value value = Empty.VALUE;
    private QueryError error;
    private InputInfo info;
    private int markedCol;
    private boolean catchable = true;

    public QueryException(Throwable cause) {
        this(Util.message(cause));
        this.initCause(cause);
    }

    public QueryException(String message) {
        this(null, QueryError.BASEX_ERROR_X, message);
    }

    public QueryException(InputInfo info, QueryError error, Object ... ext) {
        this(info, error.qname(), error.message(), ext);
        this.error = error;
    }

    public QueryException(InputInfo info, QNm name, String message, Object ... ext) {
        super(QueryException.message(message, ext, info));
        this.name = name;
        if (info != null) {
            this.info(info);
        }
        for (Object o : ext) {
            if (!(o instanceof Throwable)) continue;
            this.initCause((Throwable)o);
            break;
        }
    }

    public final int column() {
        return this.info == null ? 0 : this.info.column();
    }

    public final int markedColumn() {
        return this.markedCol;
    }

    public final int line() {
        return this.info == null ? 0 : this.info.line();
    }

    public final String path() {
        return this.info == null ? null : this.info.path();
    }

    public final QueryException suggest(InputParser qp) {
        this.pos(qp);
        return this;
    }

    public final QueryException add(InputInfo ii) {
        if (ii != null) {
            this.stack.add(ii);
        }
        return this;
    }

    public final QueryException info(InputInfo ii) {
        this.info = ii;
        return this;
    }

    public final InputInfo info() {
        return this.info;
    }

    public final QueryException value(Value val) {
        this.value = val;
        return this;
    }

    final QueryException error(QueryError err) {
        this.error = err;
        return this;
    }

    final void pos(InputParser parser) {
        this.markedCol = parser.mark;
        if (this.info != null) {
            return;
        }
        parser.pos = Math.min(parser.mark, parser.length);
        this.info = parser.info();
    }

    public final QNm qname() {
        return this.name;
    }

    public final QueryError error() {
        return this.error;
    }

    public final Value value() {
        return this.value;
    }

    public final boolean matches(QueryError.ErrType type) {
        return this.error != null && this.error.toString().startsWith(type.name());
    }

    @Override
    public final String getLocalizedMessage() {
        return super.getMessage();
    }

    @Override
    public final String getMessage() {
        byte[] code;
        TokenBuilder tb = new TokenBuilder();
        if (this.info != null) {
            tb.add(Text.STOPPED_AT).add(this.info).add(":").add(Text.NL);
        }
        if ((code = this.name.local()).length != 0) {
            tb.add(91).add(this.name.prefixId(QueryText.ERROR_URI)).add("] ");
        }
        tb.add(this.getLocalizedMessage());
        if (!this.stack.isEmpty()) {
            tb.add(Text.NL).add(Text.NL).add("Stack Trace").add(":");
            for (InputInfo ii : this.stack) {
                tb.add(Text.NL).add("- ").add(ii);
            }
        }
        return tb.toString();
    }

    public final boolean isCatchable() {
        return this.catchable;
    }

    public final QueryException notCatchable() {
        this.catchable = false;
        return this;
    }

    public static Var[] variables(QueryContext qc, InputInfo info) {
        int vl = QNAMES.length;
        Var[] vars = new Var[vl];
        for (int v = 0; v < vl; ++v) {
            vars[v] = new Var(QNAMES[v], TYPES[v], qc, info);
        }
        return vars;
    }

    public ValueList values() throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        if (this.info != null) {
            tb.add(this.info).add(10);
        }
        for (InputInfo stck : this.stack) {
            tb.add(stck).add(10);
        }
        Str trace = Str.get(tb.finish());
        ValueList list = new ValueList();
        list.add(this.qname());
        list.add(Str.get(this.getLocalizedMessage()));
        list.add(this.value() != null ? this.value() : Empty.VALUE);
        list.add(this.path() != null ? Str.get(this.path()) : Empty.VALUE);
        list.add(this.line() != 0 ? Itr.get(this.line()) : Empty.VALUE);
        list.add(this.column() != 0 ? Itr.get(this.column()) : Empty.VALUE);
        list.add(Empty.VALUE);
        list.add(trace);
        list.add(QueryException.map(list));
        return list;
    }

    public XQMap map() throws QueryException {
        return QueryException.map(this.values());
    }

    private static XQMap map(ValueList values) throws QueryException {
        MapBuilder mb = new MapBuilder();
        int v = 0;
        for (Value value : values) {
            if (!value.isEmpty()) {
                mb.put((Item)STRINGS[v], value);
            }
            ++v;
        }
        return mb.map();
    }

    private static String message(String text, Object[] ext, InputInfo info) {
        TokenList list = new TokenList(ext.length);
        for (Object e : ext) {
            Object object;
            if (e instanceof ExprInfo) {
                ExprInfo ei = (ExprInfo)e;
                object = ei.toErrorString();
            } else {
                object = e;
            }
            list.add(QueryError.normalize(object, info));
        }
        return Util.info(text, list.finish());
    }

    static {
        for (int n = NAMES.length - 1; n >= 0; --n) {
            String name = NAMES[n];
            QueryException.QNAMES[n] = new QNm(QueryText.ERR_PREFIX, name, QueryText.ERROR_URI);
            QueryException.STRINGS[n] = Str.get(name);
        }
    }
}

