/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.cmd.AQuery;
import org.basex.core.jobs.Job;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryInfo;
import org.basex.query.StaticContext;
import org.basex.query.iter.Iter;
import org.basex.query.util.UriResolver;
import org.basex.query.value.Value;
import org.basex.query.value.node.FNode;
import org.basex.util.Token;

public final class QueryProcessor
extends Job
implements Closeable {
    public final StaticContext sc;
    public final QueryContext qc;
    private final String query;
    private boolean parsed;

    public QueryProcessor(String query, Context ctx) {
        this(query, null, ctx, null);
    }

    public QueryProcessor(String query, String uri, Context ctx, QueryInfo info) {
        this.query = query;
        this.qc = this.pushJob(new QueryContext(ctx, null, info));
        this.sc = new StaticContext(this.qc);
        this.sc.baseURI(uri != null && uri.isEmpty() ? "./" : uri);
    }

    public void parse() throws QueryException {
        if (this.parsed) {
            return;
        }
        try {
            this.qc.parseMain(this.query, null, this.sc);
        }
        finally {
            this.parsed = true;
            this.updating = this.qc.updating;
        }
    }

    public void compile() throws QueryException {
        this.parse();
        this.qc.compile();
    }

    public void optimize() throws QueryException {
        this.compile();
        this.qc.optimize();
    }

    public Iter iter() throws QueryException {
        this.parse();
        return this.qc.iter();
    }

    public Value value() throws QueryException {
        this.parse();
        return this.qc.value();
    }

    public void cache(AQuery cmd, int max) throws QueryException {
        this.parse();
        this.qc.cache(cmd, max);
    }

    public QueryProcessor variable(String name, Object value) throws QueryException {
        return this.variable(name, value, null);
    }

    public QueryProcessor variable(String name, Object value, String type) throws QueryException {
        this.qc.bind(name, value, type, this.sc);
        return this;
    }

    public QueryProcessor context(Object value) throws QueryException {
        return this.context(value, null);
    }

    public QueryProcessor context(Object value, String type) throws QueryException {
        this.qc.bind(null, value, type, this.sc);
        return this;
    }

    public QueryProcessor namespace(String prefix, String uri) throws QueryException {
        this.sc.namespace(prefix, uri);
        return this;
    }

    public QueryProcessor uriResolver(UriResolver resolver) {
        this.sc.resolver = resolver;
        return this;
    }

    public Serializer serializer(OutputStream os) throws IOException, QueryException {
        this.compile();
        try {
            return Serializer.get(os, this.qc.parameters()).sc(this.sc);
        }
        catch (QueryIOException ex) {
            throw ex.getCause();
        }
    }

    public void module(String uri, String file) {
        this.qc.modDeclared.put(Token.token(uri), Token.token(file));
    }

    @Override
    public void close() {
        this.qc.close();
    }

    @Override
    public void addLocks() {
        this.qc.addLocks();
    }

    public int updates() {
        return this.updating ? this.qc.updates().size() : 0;
    }

    public FNode toXml() {
        return this.qc.toXml(this.qc.context.options.get(MainOptions.FULLPLAN));
    }

    public String toString() {
        return this.query;
    }
}

