/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import java.util.IdentityHashMap;
import org.basex.core.users.Perm;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CAttr;
import org.basex.query.expr.constr.CElem;
import org.basex.query.expr.constr.CName;
import org.basex.query.expr.constr.CNode;
import org.basex.query.expr.constr.CPI;
import org.basex.query.iter.Iter;
import org.basex.query.up.Updates;
import org.basex.query.up.expr.Update;
import org.basex.query.up.primitives.node.RenameNode;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjectMap;

public final class Rename
extends Update {
    public Rename(InputInfo info, Expr trg, Expr name) {
        super(info, trg, name);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Iter iter = this.arg(0).iter(qc);
        Item name = this.arg(1).atomItem(qc, this.info);
        IdentityHashMap<Type, QNm> names = new IdentityHashMap<Type, QNm>();
        while ((item = iter.next()) != null) {
            boolean pi;
            Type type = item.type;
            boolean element = type == NodeType.ELEMENT;
            boolean attribute = type == NodeType.ATTRIBUTE;
            boolean bl = pi = type == NodeType.PROCESSING_INSTRUCTION;
            if (!(element || attribute || pi)) {
                throw QueryError.UPWRTRGTYP_X.get(this.info, item);
            }
            QNm newName = (QNm)names.get(type);
            if (newName == null) {
                CName cname = element ? new CElem(this.info, false, (Expr)name, new Atts(), new Expr[0]) : (attribute ? new CAttr(this.info, false, (Expr)name, Empty.VALUE) : new CPI(this.info, false, (Expr)name, (Expr)Empty.VALUE));
                newName = ((ANode)((CNode)cname).item(qc, this.info)).qname();
                names.put(type, newName);
            }
            ANode target = (ANode)item;
            if (element || attribute) {
                byte[] newPrefix = newName.prefix();
                byte[] newUri = newName.uri();
                if (element || newPrefix.length > 0) {
                    Atts nspaces = target.nsScope(this.sc());
                    int ns = nspaces.size();
                    for (int n = 0; n < ns; ++n) {
                        byte[] prefix = nspaces.name(n);
                        byte[] uri = nspaces.value(n);
                        if (!Token.eq(prefix, newPrefix) || Token.eq(uri, newUri)) continue;
                        throw QueryError.UPNSCONFL_X_X.get(this.info, newName, new QNm(prefix, uri));
                    }
                }
            }
            Updates updates = qc.updates();
            DBNode dbnode = updates.determineDataRef(target, qc);
            this.checkPerm(qc, Perm.WRITE, dbnode.data().meta.name);
            updates.add(new RenameNode(dbnode.pre(), dbnode.data(), this.info, newName), qc);
        }
        return Empty.VALUE;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Rename(this.info, this.arg(0).copy(cc, vm), this.arg(1).copy(cc, vm)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Rename && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("rename").token("node").token(this.arg(0)).token("as").token(this.arg(1));
    }
}

