/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.db;

import java.io.IOException;
import org.basex.core.Store;
import org.basex.data.Data;
import org.basex.index.resource.ResourceType;
import org.basex.io.IOFile;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.db.DBUpdate;
import org.basex.query.value.Value;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjectMap;

public final class DBPut
extends DBUpdate {
    private final TokenObjectMap<Value> paths = new TokenObjectMap();

    public DBPut(Data data, Value value, String path, InputInfo info) {
        super(UpdateType.DBPUT, data, info);
        this.paths.put(Token.token(path), value);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void apply() throws QueryException {
        for (byte[] path : this.paths) {
            IOFile bin = this.data.meta.file(Token.string(path), ResourceType.VALUE);
            bin.parent().md();
            try (DataOutput out = new DataOutput(bin);){
                Store.write(out, this.paths.get(path));
            }
            catch (IOException ex) {
                Util.debug(ex);
                throw QueryError.UPDBPUT_X.get(this.info, new Object[]{path});
            }
        }
    }

    @Override
    public void merge(Update update) throws QueryException {
        TokenObjectMap<Value> put = ((DBPut)update).paths;
        for (byte[] path : put) {
            if (this.paths.contains(path)) {
                throw QueryError.DB_CONFLICT5_X.get(this.info, new Object[]{path});
            }
            this.paths.put(path, put.get(path));
        }
    }

    @Override
    public int size() {
        return this.paths.size();
    }
}

