/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import org.basex.query.StaticContext;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.RecordField;
import org.basex.query.value.type.RecordType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.hash.WeakTokenSet;

public final class SharedData {
    private final TokenObjectMap<QNm> qnames = new TokenObjectMap();
    private final WeakTokenSet tokens = new WeakTokenSet();
    private final IntObjectMap<ArrayList<RecordType>> recordTypes = new IntObjectMap();

    public SharedData() {
        this.record(SeqType.RECORD);
        this.record(SeqType.PAIR);
        this.record(SeqType.MEMBER);
    }

    public QNm parseQName(byte[] token, boolean elem, StaticContext sc) {
        byte[] name = Token.trim(token);
        if (XMLToken.isQName(name)) {
            byte[] prefix = Token.prefix(name);
            byte[] uri = prefix.length != 0 || elem ? sc.ns.uri(prefix) : null;
            return this.qName(name, uri);
        }
        Matcher matcher = QNm.EQNAME.matcher(Token.string(name));
        if (matcher.matches()) {
            byte[] nm = Token.token(matcher.group(2));
            byte[] uri = Token.token(matcher.group(1));
            if (XMLToken.isNCName(nm)) {
                return this.qName(nm, uri);
            }
        }
        return null;
    }

    public QNm qName(byte[] name) {
        return this.qName(name, null);
    }

    public QNm qName(byte[] name, byte[] uri) {
        return this.qnames.computeIfAbsent(uri != null ? Token.concat(name, Token.cpToken(32), uri) : name, () -> new QNm(name, uri));
    }

    public byte[] token(byte[] token) {
        return token.length == 0 ? Token.EMPTY : this.tokens.put(token);
    }

    public RecordType record(boolean extensible, TokenObjectMap<RecordField> fields) {
        return this.record(new RecordType(extensible, fields));
    }

    public RecordType record(Str key, SeqType type) {
        TokenObjectMap<RecordField> map = new TokenObjectMap<RecordField>(1L);
        map.put(key.string(), new RecordField(false, type));
        return this.record(new RecordType(false, map));
    }

    public RecordType record(Str key1, SeqType type1, Str key2, SeqType type2) {
        TokenObjectMap<RecordField> map = new TokenObjectMap<RecordField>(2L);
        map.put(key1.string(), new RecordField(false, type1));
        map.put(key2.string(), new RecordField(false, type2));
        return this.record(new RecordType(false, map));
    }

    public RecordType record(RecordType rt) {
        ArrayList types = this.recordTypes.computeIfAbsent(rt.fields().size(), ArrayList::new);
        for (RecordType type : types) {
            if (!type.equals(rt)) continue;
            return type;
        }
        types.add(rt);
        return rt;
    }
}

