/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.basex.local;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQDataSource;
import javax.xml.xquery.XQException;
import net.xqj.basex.local.BaseXXQConnection;
import net.xqj.basex.local.BasicConnectionImpl;
import net.xqj.basic.BasicConnection;
import net.xqj.core.GenericXQDataSource;
import net.xqj.core.Version;
import net.xqj.core.exception.XQExceptionImpl;

public class BaseXXQDataSource
extends GenericXQDataSource
implements XQDataSource {
    private Properties properties = new Properties();
    private static final String DATABASE_NAME = "databaseName";
    private static final String DESCRIPTION = "description";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static boolean isBaseXAvailable = false;

    public BaseXXQDataSource() {
        this.properties.setProperty(DESCRIPTION, Version.getProductName() + " (Local) " + Version.getProductVersion());
    }

    private BasicConnection createBasicConnectionInstance() throws XQException {
        BasicConnectionImpl conn = new BasicConnectionImpl();
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            String propertyValue = this.properties.getProperty(propertyName);
            conn.hint(propertyName, propertyValue);
        }
        return conn;
    }

    @Override
    public XQConnection getConnection() throws XQException {
        BaseXXQDataSource.assertBaseXAvailable();
        return new BaseXXQConnection(this.createBasicConnectionInstance(), this);
    }

    @Override
    public XQConnection getConnection(String username, String passwd) throws XQException {
        BaseXXQDataSource.assertBaseXAvailable();
        BasicConnection conn = this.createBasicConnectionInstance();
        conn.hint(USER, username);
        conn.hint(PASSWORD, passwd);
        return new BaseXXQConnection(conn, this);
    }

    @Override
    public XQConnection getConnection(Connection con) throws XQException {
        throw new XQExceptionImpl(this.getClass().getName() + ".getConnection(java.sql.Connection c) is unsupported.", "XQJBS001");
    }

    public void setDatabaseName(String databaseName) {
        this.properties.setProperty(DATABASE_NAME, databaseName);
    }

    public String getDatabaseName() {
        return this.properties.getProperty(DATABASE_NAME);
    }

    public void setUser(String user) {
        this.properties.setProperty(USER, user);
    }

    public String getUser() {
        return this.properties.getProperty(USER);
    }

    public void setPassword(String password) {
        this.properties.setProperty(PASSWORD, password);
    }

    public String getPassword() {
        return this.properties.getProperty(PASSWORD);
    }

    @Override
    public void setReadOnly(String readOnly) throws XQException {
        super.setReadOnly(readOnly);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws XQException {
        super.setReadOnly(readOnly);
    }

    @Override
    public boolean getReadOnly() throws XQException {
        return super.getReadOnly();
    }

    @Override
    public String[] getSupportedPropertyNames() {
        String[] generic = super.getSupportedPropertyNames();
        String[] specific = new String[]{DATABASE_NAME, USER, PASSWORD};
        String[] complete = new String[generic.length + specific.length];
        System.arraycopy(generic, 0, complete, 0, generic.length);
        System.arraycopy(specific, 0, complete, generic.length, specific.length);
        return complete;
    }

    @Override
    public void setProperty(String name, String value) throws XQException {
        if (DATABASE_NAME.equals(name)) {
            this.setDatabaseName(value);
        } else if (USER.equals(name)) {
            this.setUser(value);
        } else if (PASSWORD.equals(name)) {
            this.setPassword(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public String getProperty(String name) throws XQException {
        if (DATABASE_NAME.equals(name) || USER.equals(name) || PASSWORD.equals(name)) {
            return this.properties.getProperty(name);
        }
        return super.getProperty(name);
    }

    private static final void assertBaseXAvailable() throws XQException {
        if (isBaseXAvailable) {
            return;
        }
        try {
            Class.forName("org.basex.core.Context");
            isBaseXAvailable = true;
        }
        catch (Throwable e) {
            isBaseXAvailable = false;
            throw new XQExceptionImpl("BaseX libraries are not on the classpath, tried looking for 'org.basex.core.Context'.", "XQJ-NOBASEX");
        }
    }
}

