/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemAccessor;
import javax.xml.xquery.XQItemType;
import net.xqj.core.Factory;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.proxy.XQueryModuleProxy;
import net.xqj.core.util.CharArrayWriter;
import net.xqj.core.util.ClassTester;
import net.xqj.core.util.xmlcalendar.DurationImpl;
import net.xqj.core.util.xmlcalendar.XMLGregorianCalendarImpl;
import net.xqj.core.xqitem.AbstractAtomicXQItem;
import net.xqj.core.xqitem.XQItemBase;
import net.xqj.core.xqitem.xstream.XStreamHelper;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public final class XQItemToObjectConverter {
    public static final Object createObject(XQItemBase value) throws XQException {
        return XQItemToObjectConverter.createObject(value, null);
    }

    public static final Object createObject(XQItemBase value, Class serializeAs) throws XQException {
        XQItemType type = value.getItemType();
        switch (type.getItemKind()) {
            case 1: {
                return XQItemToObjectConverter.createObject((AbstractAtomicXQItem)value);
            }
            case 2: 
            case 13: {
                if (ClassTester.isAttr(serializeAs)) {
                    return value.getNode();
                }
                if (ClassTester.isXQItem(serializeAs)) {
                    return value;
                }
            }
            case 3: {
                if (ClassTester.isComment(serializeAs)) {
                    return value.getNode();
                }
                if (!ClassTester.isXQItem(serializeAs)) break;
                return value;
            }
            case 4: {
                if (ClassTester.isDocumentFragment(serializeAs)) {
                    return (DocumentFragment)value.getNode();
                }
                if (ClassTester.isString(serializeAs)) {
                    return value.getItemAsString(null);
                }
                if (ClassTester.isReader(serializeAs)) {
                    return XQItemToObjectConverter.createReader(value);
                }
                if (ClassTester.isInputStream(serializeAs)) {
                    return XQItemToObjectConverter.createInputStream(value);
                }
                if (!ClassTester.isXQItem(serializeAs)) break;
                return value;
            }
            case 5: 
            case 6: {
                if (ClassTester.isDocument(serializeAs)) {
                    return (Document)value.getNode();
                }
                if (ClassTester.isXMLStreamReader(serializeAs)) {
                    return value.getItemAsStream();
                }
                if (ClassTester.isSource(serializeAs)) {
                    return Factory.newSource(value.getItemAsStream());
                }
                if (ClassTester.isString(serializeAs)) {
                    return value.getItemAsString(null);
                }
                if (ClassTester.isReader(serializeAs)) {
                    return XQItemToObjectConverter.createReader(value);
                }
                if (ClassTester.isInputStream(serializeAs)) {
                    return XQItemToObjectConverter.createInputStream(value);
                }
                if (ClassTester.isXQItem(serializeAs)) {
                    return value;
                }
                return XQItemToObjectConverter.createObjectViaXStream(value);
            }
            case 7: 
            case 12: {
                if (ClassTester.isElement(serializeAs)) {
                    return (Element)value.getNode();
                }
                if (ClassTester.isXMLStreamReader(serializeAs)) {
                    return value.getItemAsStream();
                }
                if (ClassTester.isSource(serializeAs)) {
                    return Factory.newSource(value.getItemAsStream());
                }
                if (ClassTester.isString(serializeAs)) {
                    return value.getItemAsString(null);
                }
                if (ClassTester.isReader(serializeAs)) {
                    return XQItemToObjectConverter.createReader(value);
                }
                if (ClassTester.isInputStream(serializeAs)) {
                    return XQItemToObjectConverter.createInputStream(value);
                }
                if (ClassTester.isXQItem(serializeAs)) {
                    return value;
                }
                return XQItemToObjectConverter.createObjectViaXStream(value);
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                if (ClassTester.isProcessingInstruction(serializeAs)) {
                    return value.getNode();
                }
                if (!ClassTester.isXQItem(serializeAs)) break;
                return value;
            }
            case 11: {
                if (ClassTester.isText(serializeAs)) {
                    return value.getNode();
                }
                if (!ClassTester.isXQItem(serializeAs)) break;
                return value;
            }
        }
        return null;
    }

    public static final Object createObjectViaXStream(XQItemAccessor value) throws XQException {
        if (!XQueryModuleProxy.isXStreamAvailable()) {
            throw new XQExceptionImpl("Unable to unmarshal XML tree to a Java Object. To enable this functionality, place XStream on the classpath. Visit http://xstream.codehaus.org/", "XQJ-MISSING-XSTREAM");
        }
        String documentAsString = value.getItemAsString(null);
        return XStreamHelper.fromXML(documentAsString);
    }

    public static final Object createObject(AbstractAtomicXQItem value) throws XQException {
        XQItemType itemType = value.getItemType();
        switch (itemType.getBaseType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return value.getItemAsString(null);
            }
            case 6: {
                try {
                    return DurationImpl.parse(value.getItemAsString(null));
                }
                catch (IllegalArgumentException e) {
                    throw new XQExceptionImpl("Encountered problem parsing xs:dayTimeDuration.", "XQJCO001", e);
                }
            }
            case 7: {
                try {
                    return DurationImpl.parse(value.getItemAsString(null));
                }
                catch (IllegalArgumentException e) {
                    throw new XQExceptionImpl("Encountered problem parsing xs:yearMonthDuration.", "XQJCO002", e);
                }
            }
            case 8: {
                return value.getItemAsString(null);
            }
            case 9: {
                return XQToolkit.getByteArrayFromBase64(value.getItemAsString(null));
            }
            case 10: {
                return XQToolkit.parseXSDBoolean(value.getItemAsString(null));
            }
            case 11: {
                try {
                    return XMLGregorianCalendarImpl.parse(value.getItemAsString(null));
                }
                catch (IllegalArgumentException e) {
                    throw new XQExceptionImpl("Encountered problem parsing xs:date string.", "XQJCO004", e);
                }
            }
            case 12: {
                return Integer.valueOf(value.getItemAsString(null));
            }
            case 13: {
                return new BigInteger(value.getItemAsString(null));
            }
            case 14: {
                return Short.valueOf(value.getItemAsString(null));
            }
            case 15: {
                return Long.valueOf(value.getItemAsString(null));
            }
            case 16: {
                try {
                    return XMLGregorianCalendarImpl.parse(value.getItemAsString(null));
                }
                catch (IllegalArgumentException e) {
                    throw new XQExceptionImpl("Encountered problem parsing xs:dateTime string.", "XQJCO006", e);
                }
            }
            case 17: {
                return new BigDecimal(value.getItemAsString(null));
            }
            case 18: {
                return Double.valueOf(value.getItemAsString(null));
            }
            case 19: {
                try {
                    return DurationImpl.parse(value.getItemAsString(null));
                }
                catch (IllegalArgumentException e) {
                    throw new XQExceptionImpl("Encountered problem parsing xs:duration string.", "XQJCO007", e);
                }
            }
            case 20: {
                return Float.valueOf(value.getItemAsString(null));
            }
            case 21: {
                try {
                    return XMLGregorianCalendarImpl.parse(value.getItemAsString(null));
                }
                catch (IllegalArgumentException e) {
                    throw new XQExceptionImpl("Encountered problem parsing xs:gDay string.", "XQJCO009", e);
                }
            }
            case 22: {
                try {
                    return XMLGregorianCalendarImpl.parse(value.getItemAsString(null));
                }
                catch (IllegalArgumentException e) {
                    throw new XQExceptionImpl("Encountered problem parsing xs:gMonth string.", "XQJCO011", e);
                }
            }
            case 23: {
                try {
                    return XMLGregorianCalendarImpl.parse(value.getItemAsString(null));
                }
                catch (IllegalArgumentException e) {
                    throw new XQExceptionImpl("Encountered problem parsing xs:gMonthDay string.", "XQJCO013", e);
                }
            }
            case 24: {
                try {
                    return XMLGregorianCalendarImpl.parse(value.getItemAsString(null));
                }
                catch (IllegalArgumentException e) {
                    throw new XQExceptionImpl("Encountered problem parsing xs:gYear string.", "XQJCO015", e);
                }
            }
            case 25: {
                try {
                    return XMLGregorianCalendarImpl.parse(value.getItemAsString(null));
                }
                catch (IllegalArgumentException e) {
                    throw new XQExceptionImpl("Encountered problem parsing xs:gYearMonth string.", "XQJCO017", e);
                }
            }
            case 26: {
                return XQToolkit.hexStringToByteArray(value.getItemAsString(null));
            }
            case 27: {
                throw new XQExceptionImpl("Converting xs:NOTATION to a Java Object is not supported.", "XQJCO018");
            }
            case 28: {
                return XQToolkit.getQName(value.getItemAsString(null), value.getNodeUri().toString());
            }
            case 29: {
                return value.getItemAsString(null);
            }
            case 30: {
                return XMLGregorianCalendarImpl.parse(value.getItemAsString(null));
            }
            case 31: {
                return Byte.valueOf(value.getItemAsString(null));
            }
            case 32: {
                return new BigInteger(value.getItemAsString(null));
            }
            case 33: {
                return new BigInteger(value.getItemAsString(null));
            }
            case 34: {
                return new BigInteger(value.getItemAsString(null));
            }
            case 35: {
                return new BigInteger(value.getItemAsString(null));
            }
            case 36: {
                return new BigInteger(value.getItemAsString(null));
            }
            case 37: {
                return Long.valueOf(value.getItemAsString(null));
            }
            case 38: {
                return Integer.valueOf(value.getItemAsString(null));
            }
            case 39: {
                return Short.valueOf(value.getItemAsString(null));
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                return value.getItemAsString(null);
            }
        }
        throw new XQExceptionImpl("XQItemType.getBaseType() == (" + itemType.getBaseType() + "). This is not recognised. Not supported.", "XQJCO019");
    }

    public static final InputStream createInputStream(XQItemBase value) throws XQException {
        ByteArrayOutputStream bin = new ByteArrayOutputStream(1024);
        value.writeItem(bin, null);
        return new ByteArrayInputStream(bin.toByteArray());
    }

    public static final Reader createReader(XQItemBase value) throws XQException {
        CharArrayWriter writer = new CharArrayWriter();
        value.writeItem(writer, null);
        return new CharArrayReader(writer.toCharArray());
    }
}

